"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedSeriesRow = ExpandedSeriesRow;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../configurations/constants");
var _report_definition_col = require("./columns/report_definition_col");
var _operation_type_select = require("./columns/operation_type_select");
var _lens_attributes = require("../configurations/lens_attributes");
var _series_filter = require("./columns/series_filter");
var _date_picker_col = require("./columns/date_picker_col");
var _breakdowns = require("./breakdown/breakdowns");
var _label_breakdown = require("./breakdown/label_breakdown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumnType(seriesConfig, selectedMetricField) {
  const metricOption = (0, _lens_attributes.parseCustomFieldName)(seriesConfig, selectedMetricField);
  if (!Array.isArray(metricOption)) {
    return metricOption === null || metricOption === void 0 ? void 0 : metricOption.columnType;
  }
}
function ExpandedSeriesRow(seriesProps) {
  const {
    seriesConfig,
    series,
    seriesId
  } = seriesProps;
  if (!seriesConfig) {
    return null;
  }
  const {
    selectedMetricField
  } = series !== null && series !== void 0 ? series : {};
  const {
    hasOperationType,
    yAxisColumns
  } = seriesConfig;
  const columnType = getColumnType(seriesConfig, selectedMetricField);

  // if the breakdown field is percentiles, we can't apply further operations
  const hasPercentileBreakdown = series.breakdown === _constants.PERCENTILE;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: DATE_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_date_picker_col.DatePickerCol, seriesProps))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_report_definition_col.ReportDefinitionCol, {
    seriesConfig: seriesConfig,
    seriesId: seriesId,
    series: series
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: FILTERS_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_series_filter.SeriesFilter, {
    seriesConfig: seriesConfig,
    seriesId: seriesId,
    series: series
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: BREAKDOWN_BY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_breakdowns.Breakdowns, seriesProps)), /*#__PURE__*/_react.default.createElement(_label_breakdown.LabelsBreakdown, seriesProps)))), (hasOperationType || columnType === 'operation' && !hasPercentileBreakdown) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: OPERATION_LABEL
  }, /*#__PURE__*/_react.default.createElement(_operation_type_select.OperationTypeSelect, (0, _extends2.default)({}, seriesProps, {
    defaultOperationType: yAxisColumns[0].operationType
  }))))));
}
const BREAKDOWN_BY_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.breakdownBy', {
  defaultMessage: 'Breakdown by'
});
const FILTERS_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.selectFilters', {
  defaultMessage: 'Filters'
});
const OPERATION_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.operation', {
  defaultMessage: 'Operation'
});
const DATE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.date', {
  defaultMessage: 'Date'
});