"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAvailableIndices = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _get_available_indices = require("../helpers/get_available_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedDateMs = (dateStr, roundUp = false) => {
  const date = _datemath.default.parse(dateStr, roundUp ? {
    roundUp: true
  } : undefined);
  if (!(date !== null && date !== void 0 && date.isValid())) {
    throw new Error(`Invalid date format: ${dateStr}`);
  }
  return date.valueOf();
};
const fetchAvailableIndices = async (esClient, params) => {
  var _timeSeriesIndicesWit;
  const {
    indexNameOrPattern,
    startDate,
    endDate
  } = params;
  const startDateMs = getParsedDateMs(startDate);
  const endDateMs = getParsedDateMs(endDate, true);
  const indicesCats = await esClient.cat.indices({
    index: indexNameOrPattern,
    format: 'json',
    h: 'index,creation.date'
  });
  const indicesCatsInRange = indicesCats.filter(indexInfo => {
    const creationDateMs = parseInt(indexInfo['creation.date'], 10);
    return creationDateMs >= startDateMs && creationDateMs <= endDateMs;
  });
  const timeSeriesIndicesWithDataInRangeSearchResult = await esClient.search((0, _get_available_indices.getRequestBody)(params));
  const timeSeriesIndicesWithDataInRange = ((_timeSeriesIndicesWit = timeSeriesIndicesWithDataInRangeSearchResult.aggregations) === null || _timeSeriesIndicesWit === void 0 ? void 0 : _timeSeriesIndicesWit.index.buckets.map(bucket => bucket.key)) || [];

  // Combine indices from both sources removing duplicates
  const resultingIndices = new Set();
  for (const indicesCat of indicesCatsInRange) {
    resultingIndices.add(indicesCat.index);
  }
  for (const timeSeriesIndex of timeSeriesIndicesWithDataInRange) {
    resultingIndices.add(timeSeriesIndex);
  }
  return Array.from(resultingIndices);
};
exports.fetchAvailableIndices = fetchAvailableIndices;