"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _unifiedTabs = require("@kbn/unified-tabs");
var _react = _interopRequireWildcard(require("react"));
var _session_view = require("../session_view");
var _redux = require("../../state_management/redux");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _use_preview_data = require("./use_preview_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TabsView = props => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const items = (0, _redux.useInternalStateSelector)(_redux.selectAllTabs);
  const recentlyClosedItems = (0, _redux.useInternalStateSelector)(_redux.selectRecentlyClosedTabs);
  const currentTabId = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId);
  const {
    getPreviewData
  } = (0, _use_preview_data.usePreviewData)(props.runtimeStateManager);
  const onChanged = (0, _react.useCallback)(updateState => dispatch(_redux.internalStateActions.updateTabs(updateState)), [dispatch]);
  const createItem = (0, _react.useCallback)(() => (0, _redux.createTabItem)(items), [items]);
  const renderContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_session_view.DiscoverSessionView, (0, _extends2.default)({
    key: currentTabId
  }, props)), [currentTabId, props]);
  return /*#__PURE__*/_react.default.createElement(_unifiedTabs.UnifiedTabs, {
    services: services,
    items: items,
    selectedItemId: currentTabId,
    recentlyClosedItems: recentlyClosedItems,
    createItem: createItem,
    getPreviewData: getPreviewData,
    renderContent: renderContent,
    onChanged: onChanged
  });
};
exports.TabsView = TabsView;