"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPage = void 0;
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const importNoData = () => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/(0, _react.lazy)(async () => ({
  default: (await importNoData()).AnalyticsNoDataPageKibanaProvider
})));
const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/(0, _react.lazy)(async () => ({
  default: (await importNoData()).AnalyticsNoDataPage
})));
const NoDataPage = ({
  hasESData,
  hasUserDataView,
  onDataViewCreated,
  onESQLNavigationComplete
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const noDataDependencies = (0, _react.useMemo)(() => ({
    ...services,
    coreStart: services.core,
    dataViews: {
      ...services.dataViews,
      hasData: {
        ...services.dataViews.hasData,
        // We've already called this, so we can optimize the analytics services to
        // use the already-retrieved data to avoid a double-call.
        hasESData: () => Promise.resolve(hasESData),
        hasUserDataView: () => Promise.resolve(hasUserDataView)
      }
    }
  }), [hasESData, hasUserDataView, services]);
  return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, noDataDependencies, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated,
    onESQLNavigationComplete: onESQLNavigationComplete
  }));
};
exports.NoDataPage = NoDataPage;