"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panel = Panel;
exports.PanelIndicator = PanelIndicator;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _common = require("../../../common");
var _translations = require("../../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const verticalRule = (0, _react2.css)`
  width: 1px;
  height: 65px;
  background-color: ${_uiTheme.euiThemeVars.euiColorLightShade};
`;
const verticalRuleHidden = (0, _react2.css)`
  width: 1px;
  height: 65px;
  visibility: hidden;
`;
function Panel({
  title,
  secondaryTitle,
  children
}) {
  const renderChildrenWithSeparator = panelChildren => {
    if (Array.isArray(panelChildren)) {
      return panelChildren.map((panelChild, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: index
      }, panelChild, index < panelChildren.length - 1 && /*#__PURE__*/_react.default.createElement("span", {
        css: verticalRule
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, panelChildren, /*#__PURE__*/_react.default.createElement("span", {
      css: verticalRuleHidden
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, title))), secondaryTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, secondaryTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexEnd"
  }, renderChildrenWithSeparator(children)));
}
function PanelIndicator({
  label,
  value,
  tooltip,
  isLoading,
  userHasPrivilege = true
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    tabIndex: 0
  }, `${label} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, label), /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
    hasPrivileges: userHasPrivilege,
    title: label,
    mode: "popover"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), userHasPrivilege && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    "data-test-subj": `datasetQualityDetailsSummaryKpiValue-${label}`
  }, /*#__PURE__*/_react.default.createElement("h3", null, userHasPrivilege ? value : _translations.notAvailableLabel))));
}