"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeFields = removeFields;
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _shared_imports = require("../shared_imports");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function removeFields(fieldNames, dataView, services) {
  // if we're not handed a DataViewLazy, then check to see if there's one in use
  // it'll be in the cache
  if (dataView.id && !(dataView instanceof _shared_imports.DataViewLazy)) {
    const lazy = await services.dataViews.getDataViewLazyFromCache(dataView.id);
    if (lazy) {
      fieldNames.forEach(fieldName => {
        lazy.removeRuntimeField(fieldName);
      });
    }
  }
  fieldNames.forEach(fieldName => {
    dataView.removeRuntimeField(fieldName);
  });
  try {
    services.usageCollection.reportUiCounter(_constants.pluginName, _analytics.METRIC_TYPE.COUNT, 'delete_runtime');
    // eslint-disable-next-line no-empty
  } catch {}
  try {
    if (dataView.isPersisted()) {
      await services.dataViews.updateSavedObject(dataView);
    }
  } catch (e) {
    const title = _i18n.i18n.translate('indexPatternFieldEditor.save.deleteErrorTitle', {
      defaultMessage: 'Failed to save field removal'
    });
    services.notifications.toasts.addError(e, {
      title
    });
  }
}