"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardFavoriteButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _contentManagementFavoritesPublic = require("@kbn/content-management-favorites-public");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _telemetry_constants = require("../utils/telemetry_constants");
var _kibana_services = require("../services/kibana_services");
var _dashboard_query_client = require("../services/dashboard_query_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardFavoriteButton = ({
  dashboardId
}) => {
  const dashboardFavoritesClient = (0, _react.useMemo)(() => {
    return new _contentManagementFavoritesPublic.FavoritesClient(_constants.DASHBOARD_APP_ID, _telemetry_constants.DASHBOARD_CONTENT_ID, {
      http: _kibana_services.coreServices.http,
      userProfile: _kibana_services.coreServices.userProfile,
      usageCollection: _kibana_services.usageCollectionService
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _dashboard_query_client.dashboardQueryClient
  }, /*#__PURE__*/_react.default.createElement(_contentManagementFavoritesPublic.FavoritesContextProvider, {
    favoritesClient: dashboardFavoritesClient
  }, dashboardId && /*#__PURE__*/_react.default.createElement(_contentManagementFavoritesPublic.FavoriteButton, {
    id: dashboardId
  })));
};
exports.DashboardFavoriteButton = DashboardFavoriteButton;