"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMutedRulesStats = void 0;
var _constants = require("../../../../common/constants");
var _v = require("../../../routes/benchmark_rules/get_states/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMutedRulesStats = async (soClient, encryptedSoClient, logger) => {
  try {
    const benchmarkRulesStates = await (0, _v.getCspBenchmarkRulesStatesHandler)(encryptedSoClient);
    const mutedBenchmarkRules = Object.fromEntries(Object.entries(benchmarkRulesStates).filter(([_, value]) => value.muted === true));
    const mutedRulesStats = await Promise.all(Object.values(mutedBenchmarkRules).map(async mutedBenchmarkRule => {
      const cspBenchmarkRulesSo = await soClient.get(_constants.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE, mutedBenchmarkRule.rule_id);
      const ruleMetadata = cspBenchmarkRulesSo.attributes.metadata;
      if (ruleMetadata) {
        return {
          id: ruleMetadata.id,
          name: ruleMetadata.name,
          benchmark_id: ruleMetadata.benchmark.id,
          benchmark_name: ruleMetadata.benchmark.name,
          benchmark_version: mutedBenchmarkRule.benchmark_version,
          // The state object may include different benchmark version then the latest one.
          rule_number: ruleMetadata.benchmark.rule_number,
          posture_type: ruleMetadata.benchmark.posture_type,
          section: ruleMetadata.section,
          version: ruleMetadata.version
        };
      }
      return null;
    }));
    return mutedRulesStats.filter(filteredMetadata => filteredMetadata !== null);
  } catch (e) {
    logger.error(`Failed to get rules states stats ${e}`);
    return [];
  }
};
exports.getMutedRulesStats = getMutedRulesStats;