"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Banner = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Banner = ({
  bannerConfig
}) => {
  const {
    textContent,
    textColor,
    linkColor,
    backgroundColor
  } = bannerConfig;
  const customLinkColor = linkColor || 'inherit';
  const bannerStyle = (0, _react2.css)({
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    fontSize: (0, _eui.useEuiFontSize)('s').fontSize,
    backgroundColor,
    color: textColor,
    '& a': {
      color: customLinkColor
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: bannerStyle
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    "data-test-subj": "bannerInnerWrapper"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    readOnly: true
  }, textContent)));
};
exports.Banner = Banner;