"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleSummary = SampleSummary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n2 = require("../../../../../common/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Label = _styled.default.div`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.xs};
  font-size: ${() => (0, _eui.useEuiFontSize)('s').fontSize};
  color: ${({
  theme
}) => theme.euiTheme.colors.darkestShade};
`;
function SampleSummary({
  error
}) {
  var _error$error$log, _error$error$exceptio;
  const logMessage = (_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message;
  const excMessage = (_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : _error$error$exceptio[0].message;
  const culprit = error.error.culprit;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, logMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(Label, null, _i18n.i18n.translate('xpack.apm.errorGroupDetails.logMessageLabel', {
    defaultMessage: 'Log message'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, logMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(Label, null, _i18n.i18n.translate('xpack.apm.errorGroupDetails.exceptionMessageLabel', {
    defaultMessage: 'Exception message'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, excMessage || _i18n2.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(Label, null, _i18n.i18n.translate('xpack.apm.errorGroupDetails.culpritLabel', {
    defaultMessage: 'Culprit'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, culprit || _i18n2.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
}