/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.project.TestProjectResolvers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.EmptySystemIndices;
import org.elasticsearch.indices.SystemIndices;

public class TestIndexNameExpressionResolver {
    private TestIndexNameExpressionResolver() {
    }

    public static IndexNameExpressionResolver newInstance() {
        return new IndexNameExpressionResolver(new ThreadContext(Settings.EMPTY), EmptySystemIndices.INSTANCE, TestProjectResolvers.DEFAULT_PROJECT_ONLY);
    }

    public static IndexNameExpressionResolver newInstance(ProjectResolver projectResolver) {
        return new IndexNameExpressionResolver(new ThreadContext(Settings.EMPTY), EmptySystemIndices.INSTANCE, projectResolver);
    }

    public static IndexNameExpressionResolver newInstance(ThreadContext threadContext) {
        return new IndexNameExpressionResolver(threadContext, EmptySystemIndices.INSTANCE, TestProjectResolvers.usingRequestHeader(threadContext));
    }

    public static IndexNameExpressionResolver newInstance(SystemIndices systemIndices) {
        return new IndexNameExpressionResolver(new ThreadContext(Settings.EMPTY), systemIndices, TestProjectResolvers.DEFAULT_PROJECT_ONLY);
    }

    public static IndexNameExpressionResolver newInstance(ThreadContext threadContext, SystemIndices systemIndices) {
        return new IndexNameExpressionResolver(threadContext, systemIndices, TestProjectResolvers.usingRequestHeader(threadContext));
    }

    public static IndexNameExpressionResolver newInstance(SystemIndices systemIndices, ProjectResolver projectResolver) {
        return new IndexNameExpressionResolver(new ThreadContext(Settings.EMPTY), systemIndices, projectResolver);
    }
}

