/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;

abstract class IdentifierBuilder
extends AbstractBuilder {
    private static final String BLANK_INDEX_ERROR_MESSAGE = "Blank index specified in index pattern";

    IdentifierBuilder() {
    }

    @Override
    public String visitIdentifier(EsqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.QUOTED_IDENTIFIER(), ctx.UNQUOTED_IDENTIFIER());
    }

    protected static String unquoteIdentifier(TerminalNode quotedNode, TerminalNode unquotedNode) {
        String result = quotedNode != null ? IdentifierBuilder.unquoteIdString(quotedNode.getText()) : unquotedNode.getText();
        return result;
    }

    protected static String unquoteIdString(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1).replace("``", "`");
    }

    protected static String quoteIdString(String unquotedString) {
        return "`" + unquotedString.replace("`", "``") + "`";
    }

    @Override
    public String visitClusterString(EsqlBaseParser.ClusterStringContext ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.UNQUOTED_SOURCE().getText();
    }

    @Override
    public String visitIndexString(EsqlBaseParser.IndexStringContext ctx) {
        if (ctx.UNQUOTED_SOURCE() != null) {
            return ctx.UNQUOTED_SOURCE().getText();
        }
        return IdentifierBuilder.unquote(ctx.QUOTED_STRING().getText());
    }

    @Override
    public String visitSelectorString(EsqlBaseParser.SelectorStringContext ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.UNQUOTED_SOURCE().getText();
    }

    public String visitIndexPattern(List<EsqlBaseParser.IndexPatternContext> ctx) {
        ArrayList patterns = new ArrayList(ctx.size());
        Holder hasSeenStar = new Holder((Object)false);
        ctx.forEach(c -> {
            String indexPattern = c.unquotedIndexString() != null ? c.unquotedIndexString().getText() : this.visitIndexString(c.indexString());
            String clusterString = this.visitClusterString(c.clusterString());
            String selectorString = this.visitSelectorString(c.selectorString());
            hasSeenStar.set((Object)((Boolean)hasSeenStar.get() != false || indexPattern.contains("*") ? 1 : 0));
            IdentifierBuilder.validate(clusterString, indexPattern, selectorString, c, (Boolean)hasSeenStar.get());
            patterns.add(IdentifierBuilder.reassembleIndexName(clusterString, indexPattern, selectorString));
        });
        return Strings.collectionToDelimitedString(patterns, (String)",");
    }

    private static void throwInvalidIndexNameException(String indexPattern, String message, EsqlBaseParser.IndexPatternContext ctx) {
        InvalidIndexNameException ie = new InvalidIndexNameException(indexPattern, message);
        throw new ParsingException((Exception)ie, ParserUtils.source(ctx), ie.getMessage(), new Object[0]);
    }

    private static void throwOnMixingSelectorWithCluster(String indexPattern, EsqlBaseParser.IndexPatternContext c) {
        IdentifierBuilder.throwInvalidIndexNameException(indexPattern, "Selectors are not yet supported on remote cluster patterns", c);
    }

    private static String reassembleIndexName(String clusterString, String indexPattern, String selectorString) {
        if (clusterString == null && selectorString == null) {
            return indexPattern;
        }
        StringBuilder expression = new StringBuilder();
        if (clusterString != null) {
            expression.append(clusterString).append(':');
        }
        expression.append(indexPattern);
        if (selectorString != null) {
            expression.append("::").append(selectorString);
        }
        return expression.toString();
    }

    protected static void validateClusterString(String clusterString, EsqlBaseParser.IndexPatternContext ctx) {
        if (clusterString.indexOf(58) != -1) {
            throw new ParsingException(ParserUtils.source(ctx), "cluster string [{}] must not contain ':'", clusterString);
        }
    }

    private static void validate(String clusterString, String indexPattern, String selectorString, EsqlBaseParser.IndexPatternContext ctx, boolean hasSeenStar) {
        String[] patterns = clusterString == null && selectorString == null ? indexPattern.split(",", -1) : new String[]{indexPattern};
        if (Arrays.stream(patterns = (String[])Arrays.stream(patterns).map(String::strip).toArray(String[]::new)).anyMatch(String::isBlank)) {
            IdentifierBuilder.throwInvalidIndexNameException(indexPattern, BLANK_INDEX_ERROR_MESSAGE, ctx);
        }
        if (patterns.length == 0) {
            IdentifierBuilder.throwInvalidIndexNameException(indexPattern, BLANK_INDEX_ERROR_MESSAGE, ctx);
        } else if (patterns.length == 1) {
            IdentifierBuilder.validateSingleIndexPattern(clusterString, patterns[0], selectorString, ctx, hasSeenStar);
        } else {
            for (String pattern : patterns) {
                IdentifierBuilder.validateSingleIndexPattern(null, pattern, null, ctx, hasSeenStar);
            }
        }
    }

    private static void validateSingleIndexPattern(String clusterString, String indexName, String selectorString, EsqlBaseParser.IndexPatternContext ctx, boolean hasSeenStar) {
        indexName = indexName.strip();
        if (clusterString == null && selectorString == null) {
            try {
                String[] split = RemoteClusterAware.splitIndexName((String)indexName);
                clusterString = split[0];
                indexName = split[1];
            }
            catch (IllegalArgumentException e) {
                throw new ParsingException(e, ParserUtils.source(ctx), e.getMessage(), new Object[0]);
            }
        }
        if (clusterString != null && selectorString != null) {
            IdentifierBuilder.throwOnMixingSelectorWithCluster(IdentifierBuilder.reassembleIndexName(clusterString, indexName, selectorString), ctx);
        }
        if (clusterString != null) {
            clusterString = clusterString.strip();
            IdentifierBuilder.validateClusterString(clusterString, ctx);
        }
        try {
            Tuple splitPattern = IndexNameExpressionResolver.splitSelectorExpression((String)indexName);
            if (splitPattern.v2() != null) {
                if (clusterString != null) {
                    IdentifierBuilder.throwOnMixingSelectorWithCluster(IdentifierBuilder.reassembleIndexName(clusterString, (String)splitPattern.v1(), (String)splitPattern.v2()), ctx);
                } else {
                    selectorString = (String)splitPattern.v2();
                }
            }
            indexName = (String)splitPattern.v1();
        }
        catch (InvalidIndexNameException e) {
            throw new ParsingException((Exception)((Object)e), ParserUtils.source(ctx), e.getMessage(), new Object[0]);
        }
        IdentifierBuilder.resolveAndValidateIndex(indexName, ctx, hasSeenStar);
        if (selectorString != null) {
            selectorString = selectorString.strip();
            try {
                IndexNameExpressionResolver.SelectorResolver.validateIndexSelectorString((String)indexName, (String)selectorString);
            }
            catch (InvalidIndexNameException e) {
                throw new ParsingException((Exception)((Object)e), ParserUtils.source(ctx), e.getMessage(), new Object[0]);
            }
        }
    }

    private static void resolveAndValidateIndex(String index, EsqlBaseParser.IndexPatternContext ctx, boolean hasSeenStar) {
        String tempName;
        if (index.isBlank()) {
            IdentifierBuilder.throwInvalidIndexNameException(index, BLANK_INDEX_ERROR_MESSAGE, ctx);
        }
        hasSeenStar = hasSeenStar || index.contains("*");
        if ((index = index.replace("*", "").strip()).isBlank()) {
            return;
        }
        boolean hasExclusion = index.startsWith("-");
        index = IdentifierBuilder.removeExclusion(index);
        try {
            tempName = IndexNameExpressionResolver.resolveDateMathExpression((String)index);
        }
        catch (ElasticsearchParseException e) {
            throw new ParsingException((Exception)((Object)e), ParserUtils.source(ctx), e.getMessage(), new Object[0]);
        }
        hasExclusion = tempName.startsWith("-") || hasExclusion;
        index = tempName.equals(index) ? index : IdentifierBuilder.removeExclusion(tempName);
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)index, InvalidIndexNameException::new);
        }
        catch (InvalidIndexNameException e) {
            if (hasSeenStar && hasExclusion) {
                return;
            }
            InvalidIndexNameException errorToThrow = e;
            if (e.getMessage().contains("must not contain the following characters")) {
                errorToThrow = new InvalidIndexNameException(index, e.getMessage().replace("'*',", ""));
            }
            throw new ParsingException((Exception)((Object)errorToThrow), ParserUtils.source(ctx), errorToThrow.getMessage(), new Object[0]);
        }
    }

    private static String removeExclusion(String indexPattern) {
        return indexPattern.charAt(0) == "-".charAt(0) ? indexPattern.substring(1) : indexPattern;
    }
}

