/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class RoundingValuesSource
extends ValuesSource.Numeric {
    private final ValuesSource.Numeric vs;
    private final Rounding.Prepared rounding;

    RoundingValuesSource(ValuesSource.Numeric vs, Rounding.Prepared rounding) {
        this.vs = vs;
        this.rounding = rounding;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    public long round(long value) {
        return this.rounding.round(value);
    }

    public double roundingSize(long milliSeconds, Rounding.DateTimeUnit unit) {
        return this.rounding.roundingSize(milliSeconds, unit);
    }

    public double roundingSize(Rounding.DateTimeUnit unit) {
        return this.rounding.roundingSize(unit);
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        SortedNumericDocValues values = this.vs.longValues(context);
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        return singleton != null ? DocValues.singleton((NumericDocValues)this.longSingleValues(singleton)) : this.longMultiValues(values);
    }

    private SortedNumericDocValues longMultiValues(final SortedNumericDocValues values) {
        return new SortedNumericDocValues(){

            public long nextValue() throws IOException {
                return RoundingValuesSource.this.round(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public int docID() {
                return values.docID();
            }

            public int nextDoc() throws IOException {
                return values.nextDoc();
            }

            public int advance(int target) throws IOException {
                return values.advance(target);
            }

            public long cost() {
                return values.cost();
            }
        };
    }

    private NumericDocValues longSingleValues(final NumericDocValues values) {
        return new NumericDocValues(){

            public long longValue() throws IOException {
                return RoundingValuesSource.this.round(values.longValue());
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public int docID() {
                return values.docID();
            }

            public int nextDoc() throws IOException {
                return values.nextDoc();
            }

            public int advance(int target) throws IOException {
                return values.advance(target);
            }

            public long cost() {
                return values.cost();
            }
        };
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

