/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.util.PlainIterator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.ShardSearchContextId;

public final class SearchShardIterator
implements Comparable<SearchShardIterator> {
    private final OriginalIndices originalIndices;
    private final String clusterAlias;
    private final ShardId shardId;
    private boolean skip;
    private final boolean prefiltered;
    private final ShardSearchContextId searchContextId;
    private final TimeValue searchContextKeepAlive;
    private final PlainIterator<String> targetNodesIterator;

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<ShardRouting> shards, OriginalIndices originalIndices) {
        this(clusterAlias, shardId, shards.stream().map(ShardRouting::currentNodeId).toList(), originalIndices, null, null, false, false);
    }

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<String> targetNodeIds, OriginalIndices originalIndices, ShardSearchContextId searchContextId, TimeValue searchContextKeepAlive, boolean prefiltered, boolean skip) {
        this.shardId = shardId;
        this.targetNodesIterator = new PlainIterator<String>(targetNodeIds);
        this.originalIndices = originalIndices;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
        this.searchContextKeepAlive = searchContextKeepAlive;
        assert (searchContextKeepAlive == null || searchContextId != null);
        this.prefiltered = prefiltered;
        this.skip = skip;
        assert (!skip || prefiltered) : "only prefiltered shards are skip-able";
    }

    public OriginalIndices getOriginalIndices() {
        return this.originalIndices;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    SearchShardTarget nextOrNull() {
        String nodeId = this.targetNodesIterator.nextOrNull();
        if (nodeId != null) {
            return new SearchShardTarget(nodeId, this.shardId, this.clusterAlias);
        }
        return null;
    }

    ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    TimeValue getSearchContextKeepAlive() {
        return this.searchContextKeepAlive;
    }

    List<String> getTargetNodeIds() {
        return this.targetNodesIterator.asList();
    }

    void reset() {
        this.targetNodesIterator.reset();
    }

    boolean skip() {
        return this.skip;
    }

    void skip(boolean skip) {
        this.skip = skip;
    }

    boolean prefiltered() {
        return this.prefiltered;
    }

    public int size() {
        return this.targetNodesIterator.size();
    }

    ShardId shardId() {
        return this.shardId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardIterator that = (SearchShardIterator)o;
        return this.shardId.equals(that.shardId) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        String clusterAlias = this.clusterAlias;
        return 31 * (31 + (clusterAlias == null ? 0 : clusterAlias.hashCode())) + this.shardId.hashCode();
    }

    @Override
    public int compareTo(SearchShardIterator o) {
        int res = this.shardId.compareTo(o.shardId);
        if (res != 0) {
            return res;
        }
        String thisClusterAlias = this.clusterAlias;
        String otherClusterAlias = o.clusterAlias;
        if (thisClusterAlias == null) {
            return otherClusterAlias == null ? 0 : -1;
        }
        if (otherClusterAlias == null) {
            return 1;
        }
        return thisClusterAlias.compareTo(otherClusterAlias);
    }
}

