/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.CoordinatorRewriteContextProvider;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

final class RequestDispatcher {
    static final Logger LOGGER = LogManager.getLogger(RequestDispatcher.class);
    private final TransportService transportService;
    private final ClusterState clusterState;
    private final FieldCapabilitiesRequest fieldCapsRequest;
    private final Task parentTask;
    private final OriginalIndices originalIndices;
    private final long nowInMillis;
    private final boolean hasFilter;
    private final Executor executor;
    private final Consumer<FieldCapabilitiesIndexResponse> onIndexResponse;
    private final BiConsumer<String, Exception> onIndexFailure;
    private final Runnable onComplete;
    private final AtomicInteger pendingRequests = new AtomicInteger();
    private final AtomicInteger executionRound = new AtomicInteger();
    private final Map<String, IndexSelector> indexSelectors;

    RequestDispatcher(ClusterService clusterService, TransportService transportService, ProjectResolver projectResolver, CoordinatorRewriteContextProvider coordinatorRewriteContextProvider, Task parentTask, FieldCapabilitiesRequest fieldCapsRequest, OriginalIndices originalIndices, long nowInMillis, String[] indices, Executor executor, Consumer<FieldCapabilitiesIndexResponse> onIndexResponse, BiConsumer<String, Exception> onIndexFailure, Runnable onComplete) {
        this.transportService = transportService;
        this.fieldCapsRequest = fieldCapsRequest;
        this.parentTask = parentTask;
        this.originalIndices = originalIndices;
        this.nowInMillis = nowInMillis;
        this.clusterState = clusterService.state();
        this.hasFilter = fieldCapsRequest.indexFilter() != null && !(fieldCapsRequest.indexFilter() instanceof MatchAllQueryBuilder);
        this.executor = executor;
        this.onIndexResponse = onIndexResponse;
        this.onIndexFailure = onIndexFailure;
        this.onComplete = new RunOnce(onComplete);
        this.indexSelectors = ConcurrentCollections.newConcurrentMap();
        ProjectState project = projectResolver.getProjectState(this.clusterState);
        for (String index : indices) {
            List<ShardIterator> shardIts;
            try {
                shardIts = clusterService.operationRouting().searchShards(project, new String[]{index}, null, null);
            }
            catch (Exception e) {
                onIndexFailure.accept(index, e);
                continue;
            }
            IndexSelector indexResult = new IndexSelector(fieldCapsRequest.clusterAlias(), shardIts, fieldCapsRequest.indexFilter(), nowInMillis, coordinatorRewriteContextProvider);
            if (indexResult.nodeToShards.isEmpty() && indexResult.unmatchedShardIds.isEmpty()) {
                onIndexFailure.accept(index, new NoShardAvailableActionException(null, "index [" + index + "] has no active shard copy"));
                continue;
            }
            this.indexSelectors.put(index, indexResult);
        }
    }

    void execute() {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                ArrayList<String> failedIndices = new ArrayList<String>(RequestDispatcher.this.indexSelectors.keySet());
                for (String failedIndex : failedIndices) {
                    IndexSelector removed = RequestDispatcher.this.indexSelectors.remove(failedIndex);
                    assert (removed != null);
                    RequestDispatcher.this.onIndexFailure.accept(failedIndex, e);
                }
                RequestDispatcher.this.onComplete.run();
            }

            @Override
            protected void doRun() {
                RequestDispatcher.this.innerExecute();
            }
        });
    }

    private void innerExecute() {
        HashMap<String, List> nodeToSelectedShards = new HashMap<String, List>();
        assert (this.pendingRequests.get() == 0) : "pending requests = " + String.valueOf(this.pendingRequests);
        ArrayList<String> failedIndices = new ArrayList<String>();
        for (Map.Entry<String, IndexSelector> entry : this.indexSelectors.entrySet()) {
            String index = entry.getKey();
            IndexSelector indexSelector = entry.getValue();
            List<ShardRouting> selectedShards = indexSelector.nextTarget(this.hasFilter);
            if (selectedShards.isEmpty()) {
                failedIndices.add(index);
                continue;
            }
            this.pendingRequests.addAndGet(selectedShards.size());
            for (ShardRouting shard : selectedShards) {
                nodeToSelectedShards.computeIfAbsent(shard.currentNodeId(), n -> new ArrayList()).add(shard.shardId());
            }
        }
        for (String string : failedIndices) {
            IndexSelector indexSelector = this.indexSelectors.remove(string);
            assert (indexSelector != null);
            Exception failure = indexSelector.getFailure();
            if (failure == null) continue;
            this.onIndexFailure.accept(string, failure);
        }
        if (nodeToSelectedShards.isEmpty()) {
            this.onComplete.run();
        } else {
            for (Map.Entry<String, IndexSelector> entry : nodeToSelectedShards.entrySet()) {
                this.sendRequestToNode(entry.getKey(), (List)((Object)entry.getValue()));
            }
        }
    }

    int executionRound() {
        return this.executionRound.get();
    }

    private void sendRequestToNode(String nodeId, List<ShardId> shardIds) {
        DiscoveryNode node = this.clusterState.nodes().get(nodeId);
        assert (node != null);
        LOGGER.debug("round {} sends field caps node request to node {} for shardIds {}", (Object)this.executionRound, (Object)node, shardIds);
        ActionListener listener = ActionListener.wrap(this::onRequestResponse, failure -> this.onRequestFailure(shardIds, (Exception)failure));
        FieldCapabilitiesNodeRequest nodeRequest = new FieldCapabilitiesNodeRequest(shardIds, this.fieldCapsRequest.fields(), this.fieldCapsRequest.filters(), this.fieldCapsRequest.types(), this.originalIndices, this.fieldCapsRequest.indexFilter(), this.nowInMillis, this.fieldCapsRequest.runtimeFields(), this.fieldCapsRequest.includeEmptyFields());
        this.transportService.sendChildRequest(node, "indices:data/read/field_caps[n]", (TransportRequest)nodeRequest, this.parentTask, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<FieldCapabilitiesNodeResponse>(ActionListener.runAfter(listener, () -> this.afterRequestsCompleted(shardIds.size())), FieldCapabilitiesNodeResponse::new, this.executor));
    }

    private void afterRequestsCompleted(int numRequests) {
        if (this.pendingRequests.addAndGet(-numRequests) == 0) {
            this.executionRound.incrementAndGet();
            this.execute();
        }
    }

    private void onRequestResponse(FieldCapabilitiesNodeResponse nodeResponse) {
        IndexSelector indexSelector;
        for (FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse : nodeResponse.getIndexResponses()) {
            if (!fieldCapabilitiesIndexResponse.canMatch()) continue;
            if (!this.fieldCapsRequest.includeEmptyFields()) {
                this.onIndexResponse.accept(fieldCapabilitiesIndexResponse);
                continue;
            }
            if (this.indexSelectors.remove(fieldCapabilitiesIndexResponse.getIndexName()) == null) continue;
            this.onIndexResponse.accept(fieldCapabilitiesIndexResponse);
        }
        for (ShardId shardId : nodeResponse.getUnmatchedShardIds()) {
            indexSelector = this.indexSelectors.get(shardId.getIndexName());
            if (indexSelector == null) continue;
            indexSelector.addUnmatchedShardId(shardId);
        }
        for (Map.Entry entry : nodeResponse.getFailures().entrySet()) {
            indexSelector = this.indexSelectors.get(((ShardId)entry.getKey()).getIndexName());
            if (indexSelector == null) continue;
            indexSelector.setFailure((ShardId)entry.getKey(), (Exception)entry.getValue());
        }
    }

    private void onRequestFailure(List<ShardId> shardIds, Exception e) {
        for (ShardId shardId : shardIds) {
            IndexSelector indexSelector = this.indexSelectors.get(shardId.getIndexName());
            if (indexSelector == null) continue;
            indexSelector.setFailure(shardId, e);
        }
    }

    private static class IndexSelector {
        private final Map<String, List<ShardRouting>> nodeToShards = new HashMap<String, List<ShardRouting>>();
        private final Set<ShardId> unmatchedShardIds = new HashSet<ShardId>();
        private final Map<ShardId, Exception> failures = new HashMap<ShardId, Exception>();

        IndexSelector(String clusterAlias, List<ShardIterator> shardIts, QueryBuilder indexFilter, long nowInMillis, CoordinatorRewriteContextProvider coordinatorRewriteContextProvider) {
            for (ShardIterator shardIt : shardIts) {
                CoordinatorRewriteContext coordinatorRewriteContext;
                boolean canMatch = true;
                ShardId shardId = shardIt.shardId();
                if (indexFilter != null && !(indexFilter instanceof MatchAllQueryBuilder) && (coordinatorRewriteContext = coordinatorRewriteContextProvider.getCoordinatorRewriteContext(shardId.getIndex())) != null) {
                    ShardSearchRequest shardRequest = new ShardSearchRequest(shardId, nowInMillis, AliasFilter.EMPTY, clusterAlias);
                    shardRequest.source(new SearchSourceBuilder().query(indexFilter));
                    try {
                        canMatch = SearchService.queryStillMatchesAfterRewrite(shardRequest, coordinatorRewriteContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (canMatch) {
                    for (ShardRouting shard : shardIt) {
                        this.nodeToShards.computeIfAbsent(shard.currentNodeId(), node -> new ArrayList()).add(shard);
                    }
                    continue;
                }
                this.unmatchedShardIds.add(shardId);
            }
        }

        synchronized Exception getFailure() {
            Exception first = null;
            for (Exception e : this.failures.values()) {
                first = IndexSelector.useOrSuppressIfDifferent(first, e);
            }
            return first;
        }

        static Exception useOrSuppressIfDifferent(Exception first, Exception second) {
            if (first == null) {
                return second;
            }
            if (ExceptionsHelper.unwrap(first, new Class[0]) != ExceptionsHelper.unwrap(second, new Class[0])) {
                first.addSuppressed(second);
            }
            return first;
        }

        synchronized void setFailure(ShardId shardId, Exception failure) {
            assert (!this.unmatchedShardIds.contains(shardId)) : "Shard " + String.valueOf(shardId) + " was unmatched already";
            this.failures.compute(shardId, (k, curr) -> IndexSelector.useOrSuppressIfDifferent(curr, failure));
        }

        synchronized void addUnmatchedShardId(ShardId shardId) {
            boolean added = this.unmatchedShardIds.add(shardId);
            assert (added) : "Shard " + String.valueOf(shardId) + " was unmatched already";
            this.failures.remove(shardId);
        }

        synchronized List<ShardRouting> nextTarget(boolean withQueryFilter) {
            if (this.nodeToShards.isEmpty()) {
                return Collections.emptyList();
            }
            Iterator<Map.Entry<String, List<ShardRouting>>> nodeIt = this.nodeToShards.entrySet().iterator();
            if (withQueryFilter) {
                ArrayList<ShardRouting> selectedShards = new ArrayList<ShardRouting>();
                HashSet<ShardId> selectedShardIds = new HashSet<ShardId>();
                while (nodeIt.hasNext()) {
                    List<ShardRouting> shards = nodeIt.next().getValue();
                    Iterator<ShardRouting> shardIt = shards.iterator();
                    while (shardIt.hasNext()) {
                        ShardRouting shard = shardIt.next();
                        if (this.unmatchedShardIds.contains(shard.shardId())) {
                            shardIt.remove();
                            continue;
                        }
                        if (!selectedShardIds.add(shard.shardId())) continue;
                        shardIt.remove();
                        selectedShards.add(shard);
                    }
                    if (!shards.isEmpty()) continue;
                    nodeIt.remove();
                }
                return selectedShards;
            }
            assert (this.unmatchedShardIds.isEmpty());
            Map.Entry<String, List<ShardRouting>> node = nodeIt.next();
            nodeIt.remove();
            return node.getValue();
        }
    }
}

