/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.nio.charset.Charset;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.logstash.RubyUtil;

@JRubyClass(name={"BufferedTokenizer"})
public class BufferedTokenizerExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final RubyString NEW_LINE = (RubyString)RubyUtil.RUBY.newString("\n").freeze(RubyUtil.RUBY.getCurrentContext());
    private RubyArray input = RubyUtil.RUBY.newArray();
    private StringBuilder headToken = new StringBuilder();
    private RubyString delimiter = NEW_LINE;
    private int sizeLimit;
    private boolean hasSizeLimit;
    private long inputSize;
    private boolean bufferFullErrorNotified = false;
    private String encodingName;

    public BufferedTokenizerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject init(ThreadContext context, IRubyObject[] args) {
        if (args.length >= 1) {
            this.delimiter = args[0].convertToString();
        }
        if (args.length == 2) {
            int sizeLimit = args[1].convertToInteger().getIntValue();
            if (sizeLimit <= 0) {
                throw new IllegalArgumentException("Size limit must be positive");
            }
            this.sizeLimit = sizeLimit;
            this.hasSizeLimit = true;
        }
        this.inputSize = 0L;
        return this;
    }

    @JRubyMethod
    public RubyArray extract(ThreadContext context, IRubyObject data) {
        RubyEncoding encoding = (RubyEncoding)data.convertToString().encoding(context);
        this.encodingName = encoding.getEncoding().getCharsetName();
        RubyArray entities = data.convertToString().split(this.delimiter, -1);
        if (!this.bufferFullErrorNotified) {
            this.input.clear();
            this.input.concat((IRubyObject)entities);
        } else if (this.input.isEmpty()) {
            entities.shift(context);
            this.input.concat((IRubyObject)entities);
        } else if (!entities.isEmpty()) {
            RubyString last = (RubyString)this.input.pop(context);
            RubyString nextFirst = (RubyString)entities.shift(context);
            entities.unshift((IRubyObject)last.concat((IRubyObject)nextFirst));
            this.input.concat((IRubyObject)entities);
        }
        if (this.hasSizeLimit) {
            int entitiesSize;
            if (this.bufferFullErrorNotified) {
                this.bufferFullErrorNotified = false;
                if (this.input.isEmpty()) {
                    return RubyUtil.RUBY.newArray();
                }
            }
            if (this.inputSize + (long)(entitiesSize = ((RubyString)this.input.first()).size()) > (long)this.sizeLimit) {
                this.bufferFullErrorNotified = true;
                this.headToken = new StringBuilder();
                String errorMessage = String.format("input buffer full, consumed token which exceeded the sizeLimit %d; inputSize: %d, entitiesSize %d", this.sizeLimit, this.inputSize, entitiesSize);
                this.inputSize = 0L;
                this.input.shift(context);
                throw new IllegalStateException(errorMessage);
            }
            this.inputSize += (long)entitiesSize;
        }
        if (this.input.getLength() < 2) {
            this.headToken.append(this.input.shift(context));
            return RubyUtil.RUBY.newArray();
        }
        if (this.headToken.length() > 0) {
            this.headToken.append(this.input.shift(context));
            RubyString encodedHeadToken = this.toEncodedRubyString(context, this.headToken.toString());
            this.input.unshift((IRubyObject)encodedHeadToken);
            this.headToken = new StringBuilder();
        }
        this.headToken.append(this.input.pop(context));
        this.inputSize = this.headToken.length();
        return this.input;
    }

    private RubyString toEncodedRubyString(ThreadContext context, String input) {
        RubyString result = RubyUtil.RUBY.newString(new ByteList(input.getBytes(Charset.forName(this.encodingName))));
        result.force_encoding(context, (IRubyObject)RubyUtil.RUBY.newString(this.encodingName));
        return result;
    }

    @JRubyMethod
    public IRubyObject flush(ThreadContext context) {
        RubyString encodedHeadToken;
        IRubyObject buffer = RubyUtil.toRubyObject(this.headToken.toString());
        this.headToken = new StringBuilder();
        this.inputSize = 0L;
        if (this.encodingName != null) {
            encodedHeadToken = this.toEncodedRubyString(context, buffer.toString());
        } else {
            if (!buffer.toString().isEmpty()) {
                throw new IllegalStateException("invoked flush with unassigned encoding but not empty head token, this shouldn't happen");
            }
            encodedHeadToken = (RubyString)buffer;
        }
        return encodedHeadToken;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext context) {
        return RubyUtil.RUBY.newBoolean(this.headToken.toString().isEmpty() && this.inputSize == 0L);
    }
}

