/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.logstash.Event;
import org.logstash.dissect.ConvertPair;
import org.logstash.dissect.DissectPair;
import org.logstash.dissect.DissectResult;
import org.logstash.dissect.Dissector;
import org.logstash.dissect.DynamicMethodCache;
import org.logstash.dissect.fields.InvalidFieldException;
import org.logstash.ext.JrubyEventExtLibrary;

public class JavaDissectorLibrary
implements Library {
    private static final Logger LOGGER = LogManager.getLogger(Dissector.class);

    public final void load(Ruby runtime, boolean wrap) {
        RubyModule module = runtime.defineModule("LogStash");
        RubyClass clazz = runtime.defineClassUnder("Dissector", runtime.getObject(), RubyDissect::new, module);
        clazz.defineAnnotatedMethods(RubyDissect.class);
        RubyClass runtimeError = runtime.getRuntimeError();
        module.defineClassUnder("FieldFormatError", runtimeError, runtimeError.getAllocator());
        module.defineClassUnder("ConvertDatatypeFormatError", runtimeError, runtimeError.getAllocator());
    }

    public static class RubyDissect
    extends RubyObject {
        private static final long serialVersionUID = -4417443116118527316L;
        static final String FILTER_MATCHED = "filter_matched";
        static final String INCREMENT_MATCHES_METRIC = "increment_matches_metric";
        static final String INCREMENT_FAILURES_METRIC = "increment_failures_metric";
        static final String TAG_ON_FAILURE = "tag_on_failure";
        static final String[] EMPTY_STRINGS_ARRAY = new String[0];
        private DissectPair[] dissectors = DissectPair.EMPTY_ARRAY;
        private ConvertPair[] conversions = ConvertPair.EMPTY_ARRAY;
        private RubyObject plugin;
        private RubyClass pluginMetaClass;
        private boolean runMatched = false;
        private String[] failureTags = EMPTY_STRINGS_ARRAY;

        public RubyDissect(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        public RubyDissect(Ruby runtime) {
            this(runtime, runtime.getModule("LogStash").getClass("Dissector"));
        }

        private static RubyHash addLoggableEvent(ThreadContext ctx, IRubyObject rubyEvent, RubyHash map) {
            map.put((Object)"event", (Object)rubyEvent.getMetaClass().finvoke(ctx, rubyEvent, "to_hash"));
            return map;
        }

        private static RubyHash createLoggableHash(ThreadContext ctx) {
            return RubyHash.newSmallHash((Ruby)ctx.runtime);
        }

        private static RubyHash createHashInclField(ThreadContext ctx, Object fieldValue) {
            RubyHash hash = RubyDissect.createLoggableHash(ctx);
            hash.put((Object)"field", fieldValue);
            return hash;
        }

        @JRubyMethod(name={"initialize"}, required=2, optional=2)
        public IRubyObject rubyInitialize(ThreadContext ctx, IRubyObject[] args) {
            Ruby ruby = ctx.runtime;
            try {
                this.dissectors = DissectPair.createArrayFromHash((RubyHash)args[0]);
            }
            catch (InvalidFieldException e) {
                throw new RaiseException((Throwable)e, NativeExceptions.newFieldFormatError(ruby, e));
            }
            this.plugin = (RubyObject)args[1];
            this.pluginMetaClass = this.plugin.getMetaClass();
            for (ConvertPair convertPair : this.conversions = ConvertPair.createArrayFromHash((RubyHash)args[2])) {
                if (!convertPair.converter().isInvalid()) continue;
                RubyClass klass = ruby.getModule("LogStash").getClass("ConvertDatatypeFormatError");
                String errorMessage = String.format("Dissector datatype conversion, datatype not supported: %s", convertPair.type());
                throw new RaiseException(ruby, klass, errorMessage, true);
            }
            this.runMatched = args[3] == null || args[3].isTrue();
            this.failureTags = this.fetchFailureTags(ctx);
            return ctx.nil;
        }

        @JRubyMethod(name={"dissect"}, required=1)
        public final IRubyObject dissect(ThreadContext ctx, IRubyObject arg1) {
            JrubyEventExtLibrary.RubyEvent rubyEvent = (JrubyEventExtLibrary.RubyEvent)arg1;
            if (rubyEvent.ruby_cancelled(ctx).isTrue()) {
                return ctx.nil;
            }
            Event event = rubyEvent.getEvent();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Event before dissection", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, RubyDissect.createLoggableHash(ctx)));
                }
                if (this.dissectors.length > 0) {
                    this.invokeDissection(ctx, rubyEvent, event);
                }
                if (this.conversions.length > 0) {
                    this.invokeConversions(event);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Event after dissection", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, RubyDissect.createLoggableHash(ctx)));
                }
            }
            catch (Exception ex) {
                this.invokeFailureTagsAndMetric(ctx, event);
                this.logException(ex);
            }
            return ctx.nil;
        }

        @JRubyMethod(name={"dissect_multi"}, required=1)
        public final IRubyObject dissectMulti(ThreadContext ctx, IRubyObject arg1) {
            RubyArray events = (RubyArray)arg1;
            Arrays.stream(events.toJavaArray()).forEach(event -> this.dissect(ctx, (IRubyObject)event));
            return ctx.nil;
        }

        private void invokeDissection(ThreadContext ctx, JrubyEventExtLibrary.RubyEvent rubyEvent, Event event) {
            for (DissectPair dissectPair : this.dissectors) {
                if (dissectPair.isEmpty()) continue;
                if (!event.includes(dissectPair.javaKey())) {
                    this.invokeFailuresMetric(ctx);
                    LOGGER.warn("Dissector mapping, field not found in event", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, RubyDissect.createHashInclField(ctx, dissectPair.key())));
                    continue;
                }
                RubyString src = rubyEvent.ruby_get_field(ctx, dissectPair.key()).asString();
                if (src.isNil()) {
                    LOGGER.warn("Dissector mapping, no value found for field", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, RubyDissect.createHashInclField(ctx, dissectPair.key())));
                    this.invokeFailureTagsAndMetric(ctx, event);
                    continue;
                }
                if (src.isEmpty()) {
                    this.invokeFailureTagsAndMetric(ctx, event);
                    LOGGER.warn("Dissector mapping, field found in event but it was empty", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, RubyDissect.createHashInclField(ctx, dissectPair.key())));
                    continue;
                }
                byte[] bytes = src.getBytes();
                DissectResult result = dissectPair.dissector().dissect(bytes, event);
                if (result.matched()) {
                    if (this.runMatched) {
                        this.invokeFilterMatched(ctx, (IRubyObject)rubyEvent);
                    }
                    this.invokeMatchesMetric(ctx);
                    continue;
                }
                this.invokeFailureTagsAndMetric(ctx, event);
                RubyHash loggableMap = RubyDissect.createHashInclField(ctx, dissectPair.key());
                loggableMap.put((Object)"pattern", (Object)dissectPair.dissector().getMapping());
                LOGGER.warn("Dissector mapping, pattern not found", (Object)RubyDissect.addLoggableEvent(ctx, (IRubyObject)rubyEvent, loggableMap));
            }
        }

        private void invokeConversions(Event event) {
            for (ConvertPair convertPair : this.conversions) {
                if (convertPair.converter().isInvalid()) continue;
                try {
                    convertPair.converter().convert(event, convertPair.src());
                }
                catch (NumberFormatException e) {
                    String msg;
                    Object val = event.getField(convertPair.src());
                    if (val == null) {
                        event.tag(String.format("_dataconversionnullvalue_%s_%s", convertPair.src(), convertPair.type()));
                        msg = String.format("Dissector datatype conversion, field does not exist or value is nil, field: %s", convertPair.src());
                    } else {
                        event.tag(String.format("_dataconversionuncoercible_%s_%s", convertPair.src(), convertPair.type()));
                        msg = String.format("Dissector datatype conversion, value cannot be coerced, field: %s, value: %s", convertPair.src(), String.valueOf(val));
                    }
                    LOGGER.warn(msg);
                }
            }
        }

        private void invokeFilterMatched(ThreadContext ctx, IRubyObject rubyEvent) {
            DynamicMethod method = DynamicMethodCache.get(this.pluginMetaClass, FILTER_MATCHED);
            if (!method.isUndefined()) {
                method.call(ctx, (IRubyObject)this.plugin, (RubyModule)this.pluginMetaClass, FILTER_MATCHED, new IRubyObject[]{rubyEvent});
            }
        }

        private void invokeFailureTagsAndMetric(ThreadContext ctx, Event event) {
            this.invokeFailuresMetric(ctx);
            this.invokeFailureTags(event);
        }

        private String[] fetchFailureTags(ThreadContext ctx) {
            IRubyObject obj;
            DynamicMethod method = DynamicMethodCache.get(this.pluginMetaClass, TAG_ON_FAILURE);
            String[] result = EMPTY_STRINGS_ARRAY;
            if (!method.isUndefined() && (obj = method.call(ctx, (IRubyObject)this.plugin, (RubyModule)this.pluginMetaClass, TAG_ON_FAILURE)) instanceof RubyArray) {
                RubyArray tags = (RubyArray)obj;
                result = new String[tags.size()];
                for (int idx = 0; idx < result.length; ++idx) {
                    result[idx] = tags.entry(idx).asJavaString();
                }
            }
            return result;
        }

        private void invokeFailureTags(Event event) {
            for (String tag : this.failureTags) {
                event.tag(tag);
            }
        }

        private void invokeMatchesMetric(ThreadContext ctx) {
            DynamicMethod method = DynamicMethodCache.get(this.pluginMetaClass, INCREMENT_MATCHES_METRIC);
            if (!method.isUndefined()) {
                method.call(ctx, (IRubyObject)this.plugin, (RubyModule)this.pluginMetaClass, INCREMENT_MATCHES_METRIC);
            }
        }

        private void invokeFailuresMetric(ThreadContext ctx) {
            DynamicMethod method = DynamicMethodCache.get(this.pluginMetaClass, INCREMENT_FAILURES_METRIC);
            if (!method.isUndefined()) {
                method.call(ctx, (IRubyObject)this.plugin, (RubyModule)this.pluginMetaClass, INCREMENT_FAILURES_METRIC);
            }
        }

        private void logException(Throwable exc) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("exception", exc.toString());
            map.put("backtrace", String.join((CharSequence)"\n   ", (CharSequence[])Arrays.stream(exc.getStackTrace()).limit(12L).map(StackTraceElement::toString).toArray(String[]::new)));
            LOGGER.error("Dissect threw an exception", map);
        }
    }

    private static final class NativeExceptions {
        private NativeExceptions() {
        }

        static NativeException newFieldFormatError(Ruby ruby, Throwable cause) {
            RubyClass errorClass = ruby.getModule("LogStash").getClass("FieldFormatError");
            return new NativeException(ruby, errorClass, cause);
        }
    }
}

