"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexNameSearch = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndexNameSearch = query => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndexNames', query],
    queryFn: async () => http.fetch('/internal/serverless_search/index_names', {
      query: {
        query
      }
    })
  });
};
exports.useIndexNameSearch = useIndexNameSearch;