"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportListItemsResponse = exports.ImportListItemsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _list_common = require("../model/list_common.gen");
var _list_schemas = require("../model/list_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Import value list items API endpoint
 *   version: 2023-10-31
 */

const ImportListItemsRequestQuery = exports.ImportListItemsRequestQuery = _zod.z.object({
  /** 
      * List's id.
  Required when importing to an existing list.
        */
  list_id: _list_common.ListId.optional(),
  /** 
      * Type of the importing list.
  Required when importing a new list whose list `id` is not specified.
        */
  type: _list_common.ListType.optional(),
  /** 
      * Determines how uploaded list item values are parsed. By default, list items are parsed using these named regex groups:
  - `(?<value>.+)` - Single value item types, such as ip, long, date, keyword, and text.
  - `(?<gte>.+)-(?<lte>.+)|(?<value>.+)` - Range value item types, such as `date_range`, `ip_range`, `double_range`, `float_range`, `integer_range`, and `long_range`.
        */
  serializer: _zod.z.string().optional(),
  /** 
      * Determines how retrieved list item values are presented. By default list items are presented using these Handelbar expressions:
  - `{{{value}}}` - Single value item types, such as `ip`, `long`, `date`, `keyword`, and `text`.
  - `{{{gte}}}-{{{lte}}}` - Range value item types, such as `ip_range`, `double_range`, `float_range`, `integer_range`, and `long_range`.
  - `{{{gte}}},{{{lte}}}` - Date range values.
        */
  deserializer: _zod.z.string().optional(),
  /**
   * Determines when changes made by the request are made visible to search.
   */
  refresh: _zod.z.enum(['true', 'false', 'wait_for']).optional()
});
const ImportListItemsResponse = exports.ImportListItemsResponse = _list_schemas.List;