"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindExceptionListItemsResponse = exports.FindExceptionListItemsRequestQuery = exports.FindExceptionListItemsFilter = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _exception_list_common = require("../model/exception_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find exception list items API endpoint
 *   version: 2023-10-31
 */

const FindExceptionListItemsFilter = exports.FindExceptionListItemsFilter = _primitives.NonEmptyString;
const FindExceptionListItemsRequestQuery = exports.FindExceptionListItemsRequestQuery = _zod.z.object({
  /**
   * The `list_id`s of the items to fetch.
   */
  list_id: (0, _zodHelpers.ArrayFromString)(_exception_list_common.ExceptionListHumanId),
  /** 
      * Filters the returned results according to the value of the specified field,
  using the `<field name>:<field value>` syntax.
        */
  filter: (0, _zodHelpers.ArrayFromString)(FindExceptionListItemsFilter).optional().default([]),
  /** 
      * Determines whether the returned containers are Kibana associated with a Kibana space
  or available in all spaces (`agnostic` or `single`)
        */
  namespace_type: (0, _zodHelpers.ArrayFromString)(_exception_list_common.ExceptionNamespaceType).optional().default(['single']),
  search: _zod.z.string().optional(),
  /**
   * The page number to return
   */
  page: _zod.z.coerce.number().int().min(0).optional(),
  /**
   * The number of exception list items to return per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional(),
  /**
   * Determines which field is used to sort the results.
   */
  sort_field: _primitives.NonEmptyString.optional(),
  /**
   * Determines the sort order, which can be `desc` or `asc`.
   */
  sort_order: _zod.z.enum(['desc', 'asc']).optional()
});
const FindExceptionListItemsResponse = exports.FindExceptionListItemsResponse = _zod.z.object({
  data: _zod.z.array(_exception_list_common.ExceptionListItem),
  page: _zod.z.number().int().min(1),
  per_page: _zod.z.number().int().min(1),
  total: _zod.z.number().int().min(0),
  pit: _zod.z.string().optional()
});