"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionsPreSummaryHandler = void 0;
var _stringify = require("../../../endpoint/utils/stringify");
var _errors = require("../validators/errors");
var _utils = require("../utils");
var _validators = require("../validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExceptionsPreSummaryHandler = endpointAppContextService => {
  const logger = endpointAppContextService.createLogger('listsExceptionsPreSummaryHandler');
  return async function ({
    data,
    context: {
      request,
      exceptionListClient
    }
  }) {
    if (data.namespaceType !== 'agnostic') {
      return data;
    }
    const {
      listId: maybeListId,
      id
    } = data;
    let listId = maybeListId;
    let isEndpointArtifact = false;
    if (!listId && id) {
      var _await$exceptionListC, _await$exceptionListC2;
      listId = (_await$exceptionListC = (_await$exceptionListC2 = await exceptionListClient.getExceptionList(data)) === null || _await$exceptionListC2 === void 0 ? void 0 : _await$exceptionListC2.list_id) !== null && _await$exceptionListC !== void 0 ? _await$exceptionListC : null;
    }
    if (!listId) {
      return data;
    }

    // Validate Trusted Applications
    if (_validators.TrustedAppValidator.isTrustedApp({
      listId
    })) {
      await new _validators.TrustedAppValidator(endpointAppContextService, request).validatePreGetListSummary();
      isEndpointArtifact = true;
    }

    // Host Isolation Exceptions
    if (_validators.HostIsolationExceptionsValidator.isHostIsolationException({
      listId
    })) {
      await new _validators.HostIsolationExceptionsValidator(endpointAppContextService, request).validatePreSummary();
      isEndpointArtifact = true;
    }

    // Event Filter Exceptions
    if (_validators.EventFilterValidator.isEventFilter({
      listId
    })) {
      await new _validators.EventFilterValidator(endpointAppContextService, request).validatePreSummary();
      isEndpointArtifact = true;
    }

    // Validate Blocklists
    if (_validators.BlocklistValidator.isBlocklist({
      listId
    })) {
      await new _validators.BlocklistValidator(endpointAppContextService, request).validatePreGetListSummary();
      isEndpointArtifact = true;
    }

    // Validate Endpoint Exceptions
    if (_validators.EndpointExceptionsValidator.isEndpointException({
      listId
    })) {
      await new _validators.EndpointExceptionsValidator(endpointAppContextService, request).validatePreGetListSummary();
      isEndpointArtifact = true;
    }
    if (isEndpointArtifact && endpointAppContextService.experimentalFeatures.endpointManagementSpaceAwarenessEnabled) {
      if (!request) {
        throw new _errors.EndpointArtifactExceptionValidationError(`Missing HTTP Request object`);
      }
      logger.debug(`Summary request prior to adding space filter:\n${(0, _stringify.stringify)(data)}`);
      const spaceFilter = (await (0, _utils.buildSpaceDataFilter)(endpointAppContextService, request)).filter;
      data.filter = spaceFilter + (data.filter ? ` AND (${data.filter})` : '');
      logger.debug(`Summary request after adding space filter:\n${(0, _stringify.stringify)(data)}`);
    }
    return data;
  };
};
exports.getExceptionsPreSummaryHandler = getExceptionsPreSummaryHandler;