"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accumulateUpsertResults = void 0;
var _Array = require("fp-ts/Array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const accumulateUpsertResults = (acc, processed) => {
  const {
    left: errors,
    right: users
  } = (0, _Array.separate)(processed.batch.uploaded);
  return {
    users: acc.users.concat(users),
    errors: acc.errors.concat(errors),
    failed: acc.failed + processed.failed,
    successful: acc.successful + processed.successful
  };
};
exports.accumulateUpsertResults = accumulateUpsertResults;