"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegeMonitoringRuntimePrivileges = void 0;
var _constants = require("../constants");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegeMonitoringRuntimePrivileges = sourceIndices => ({
  cluster: ['manage_ingest_pipelines', 'manage_index_templates'],
  index: [{
    names: [_constants.PRIVILEGE_MONITORING_INTERNAL_INDICES_PATTERN],
    privileges: ['create_index', 'delete_index', 'index', 'create_doc', 'auto_configure', 'read']
  }, {
    names: [...sourceIndices, _constants.PRIVILEGE_MONITORING_INTERNAL_INDICES_PATTERN],
    privileges: ['read', 'view_index_metadata']
  }],
  application: [{
    application: 'kibana-.kibana',
    privileges: [`saved_object:${_saved_objects.privilegeMonitoringTypeName}/*`],
    resources: ['*']
  }]
});
exports.privilegeMonitoringRuntimePrivileges = privilegeMonitoringRuntimePrivileges;