"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityFieldMap = exports.CRITICALITY_VALUES = exports.ASSET_CRITICALITY_MAPPINGS_VERSIONS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityMapping = {
  type: 'keyword',
  array: false,
  required: false
};

// Upgrade this value to force a mappings update on the next Kibana startup
const ASSET_CRITICALITY_MAPPINGS_VERSIONS = exports.ASSET_CRITICALITY_MAPPINGS_VERSIONS = 4;
const assetCriticalityFieldMap = exports.assetCriticalityFieldMap = {
  '@timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  id_field: {
    type: 'keyword',
    array: false,
    required: false
  },
  id_value: {
    type: 'keyword',
    array: false,
    required: false
  },
  criticality_level: assetCriticalityMapping,
  updated_at: {
    type: 'date',
    array: false,
    required: false
  },
  'asset.criticality': {
    type: 'keyword',
    array: false,
    required: true
  },
  'host.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.asset.criticality': assetCriticalityMapping,
  'user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.asset.criticality': assetCriticalityMapping,
  'event.ingested': {
    type: 'date',
    array: false,
    required: false
  },
  'service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.asset.criticality': assetCriticalityMapping,
  'entity.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'entity.asset.criticality': assetCriticalityMapping
};
const CRITICALITY_VALUES = exports.CRITICALITY_VALUES = {
  LOW_IMPACT: 'low_impact',
  MEDIUM_IMPACT: 'medium_impact',
  HIGH_IMPACT: 'high_impact',
  EXTREME_IMPACT: 'extreme_impact',
  DELETED: 'deleted'
};