"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryFields = void 0;
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryFields = async ({
  dataViews,
  index,
  query,
  language
}) => {
  const dataViewLazy = await dataViews.createDataViewLazy({
    title: index.join()
  });
  return Object.values(await (0, _common.queryToFields)({
    dataView: dataViewLazy,
    request: {
      query: [{
        query,
        language: language || 'kuery'
      }]
    }
  }));
};
exports.getQueryFields = getQueryFields;