"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyRuleUpdate = void 0;
var _apply_rule_defaults = require("./apply_rule_defaults");
var _calculate_rule_source = require("./rule_source/calculate_rule_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applyRuleUpdate = async ({
  prebuiltRuleAssetClient,
  existingRule,
  ruleUpdate
}) => {
  var _ruleUpdate$enabled, _ruleUpdate$version;
  const nextRule = {
    ...(0, _apply_rule_defaults.applyRuleDefaults)(ruleUpdate),
    // Use existing values
    enabled: (_ruleUpdate$enabled = ruleUpdate.enabled) !== null && _ruleUpdate$enabled !== void 0 ? _ruleUpdate$enabled : existingRule.enabled,
    version: (_ruleUpdate$version = ruleUpdate.version) !== null && _ruleUpdate$version !== void 0 ? _ruleUpdate$version : existingRule.version,
    // Always keep existing values for these fields
    id: existingRule.id,
    rule_id: existingRule.rule_id,
    revision: existingRule.revision,
    immutable: existingRule.immutable,
    rule_source: existingRule.rule_source,
    updated_at: existingRule.updated_at,
    updated_by: existingRule.updated_by,
    created_at: existingRule.created_at,
    created_by: existingRule.created_by
  };
  nextRule.rule_source = await (0, _calculate_rule_source.calculateRuleSource)({
    nextRule,
    currentRule: existingRule,
    prebuiltRuleAssetClient
  });
  return nextRule;
};
exports.applyRuleUpdate = applyRuleUpdate;