"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEsqlFromLastMessageStepRouter = exports.selectIndexStepRouter = exports.nlToEsqlAgentStepRouter = void 0;
var _langgraph = require("@langchain/langgraph");
var _constants = require("./constants");
var _common = require("../../utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEsqlFromLastMessageStepRouter = state => {
  const {
    validateEsqlResults,
    maximumEsqlGenerationAttempts,
    maximumValidationAttempts
  } = state;
  const containsInvalidQueries = validateEsqlResults.some(validateEsqlResult => !validateEsqlResult.isValid);
  if (validateEsqlResults.length > 0 && !containsInvalidQueries) {
    return _constants.BUILD_SUCCESS_REPORT_FROM_LAST_MESSAGE_NODE;
  }
  if (validateEsqlResults.length > 0 && containsInvalidQueries && maximumValidationAttempts > 0 && maximumEsqlGenerationAttempts > 0) {
    return _constants.BUILD_ERROR_REPORT_FROM_LAST_MESSAGE_NODE;
  }
  return _constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE;
};
exports.validateEsqlFromLastMessageStepRouter = validateEsqlFromLastMessageStepRouter;
const selectIndexStepRouter = state => {
  const {
    selectedIndexPattern
  } = state;
  if (selectedIndexPattern == null) {
    return _langgraph.END;
  }
  return _constants.NL_TO_ESQL_AGENT_NODE;
};
exports.selectIndexStepRouter = selectIndexStepRouter;
const nlToEsqlAgentStepRouter = state => {
  const {
    messages
  } = state;
  const lastMessage = messages[messages.length - 1];
  if ((0, _common.messageContainsToolCalls)(lastMessage)) {
    return _constants.TOOLS_NODE;
  }
  return _constants.VALIDATE_ESQL_FROM_LAST_MESSAGE_NODE;
};
exports.nlToEsqlAgentStepRouter = nlToEsqlAgentStepRouter;