"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveTimelineMiddleware = exports.convertTimelineAsInput = void 0;
var _fp = require("lodash/fp");
var _fp2 = require("@kbn/safer-lodash-set/fp");
var _esQuery = require("@kbn/es-query");
var _selectors = require("../../../data_view_manager/redux/selectors");
var _store = require("../../../sourcerer/store");
var _actions = require("../actions");
var _api = require("../../containers/api");
var _inputs = require("../../../common/store/inputs");
var _selectors2 = require("../selectors");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _timeline = require("../../../../common/api/timeline");
var _helpers = require("./helpers");
var _model = require("../../../sourcerer/store/model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isSaveTimelineAction(action) {
  return action.type === _actions.saveTimeline.type;
}
const saveTimelineMiddleware =
// WARN: this is disabled because we need to support experimental data view picker here.
// once it is stable, remove the override
// eslint-disable-next-line complexity
kibana => store => next => async action => {
  var _error$message;
  if (!isSaveTimelineAction(action)) {
    return next(action);
  }
  const {
    id: localTimelineId
  } = action.payload;
  const storeState = store.getState();
  const timeline = (0, _selectors2.selectTimelineById)(storeState, localTimelineId);
  const {
    timelineId,
    timelineVersion,
    templateTimelineId,
    templateTimelineVersion
  } = extractTimelineIdsAndVersions(timeline);
  const timelineTimeRange = _inputs.inputsSelectors.timelineTimeRangeSelector(storeState);
  const selectedDataViewIdSourcerer = _store.sourcererSelectors.sourcererScopeSelectedDataViewId(storeState, _model.SourcererScopeName.timeline);
  const selectedPatternsSourcerer = _store.sourcererSelectors.sourcererScopeSelectedPatterns(storeState, _model.SourcererScopeName.timeline);
  const {
    dataViewId: experimentalDataViewId
  } = (0, _selectors.sourcererAdapterSelector)(_model.SourcererScopeName.timeline)(storeState);
  const experimentalIsDataViewEnabled = storeState.app.enableExperimental.newDataViewPickerEnabled;
  let experimentalSelectedPatterns = [];

  // NOTE: remove eslint override above after the experimental picker is stabilized
  if (experimentalIsDataViewEnabled && experimentalDataViewId) {
    const plugins = await kibana.plugins.onStart('dataViews');
    if (plugins.dataViews.found) {
      const experimentalDataView = await plugins.dataViews.contract.get(experimentalDataViewId);
      if (!experimentalDataView.isPersisted()) {
        return kibana.notifications.toasts.addError(new Error('Persisting timelines with adhoc data views is not allowed'), {
          title: 'Error persisting timeline'
        });
      }
      experimentalSelectedPatterns = experimentalDataView.getIndexPattern().split(',');
    }
  }
  const indexNames = experimentalIsDataViewEnabled ? experimentalSelectedPatterns : selectedPatternsSourcerer;
  const dataViewId = experimentalIsDataViewEnabled ? experimentalDataViewId : selectedDataViewIdSourcerer;
  store.dispatch((0, _actions.startTimelineSaving)({
    id: localTimelineId
  }));
  try {
    var _response$updated, _response$status, _response$timelineTyp, _response$templateTim, _response$templateTim2, _response$savedSearch;
    const response = await (action.payload.saveAsNew && timeline.id ? (0, _api.copyTimeline)({
      timelineId,
      timeline: {
        ...convertTimelineAsInput(timeline, timelineTimeRange),
        dataViewId,
        indexNames,
        templateTimelineId,
        templateTimelineVersion
      },
      savedSearch: timeline.savedSearch
    }) : (0, _api.persistTimeline)({
      timelineId,
      version: timelineVersion,
      timeline: {
        ...convertTimelineAsInput(timeline, timelineTimeRange),
        dataViewId,
        indexNames,
        templateTimelineId,
        templateTimelineVersion
      },
      savedSearch: timeline.savedSearch
    }));
    if (isTimelineErrorResponse(response)) {
      const error = getErrorFromResponse(response);
      switch (error === null || error === void 0 ? void 0 : error.errorCode) {
        case 403:
          store.dispatch((0, _actions.showCallOutUnauthorizedMsg)());
          break;
        // conflict
        case 409:
          kibana.notifications.toasts.addDanger({
            title: i18n.TIMELINE_VERSION_CONFLICT_TITLE,
            text: i18n.TIMELINE_VERSION_CONFLICT_DESCRIPTION
          });
          break;
        default:
          kibana.notifications.toasts.addDanger({
            title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
            text: (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : i18n.UPDATE_TIMELINE_ERROR_TEXT
          });
      }
      return;
    }
    if (response == null) {
      kibana.notifications.toasts.addDanger({
        title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
        text: i18n.UPDATE_TIMELINE_ERROR_TEXT
      });
      return;
    }
    (0, _helpers.refreshTimelines)(store.getState());
    store.dispatch((0, _actions.updateTimeline)({
      id: localTimelineId,
      timeline: {
        ...timeline,
        id: response.savedObjectId,
        updated: (_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : undefined,
        savedObjectId: response.savedObjectId,
        version: response.version,
        status: (_response$status = response.status) !== null && _response$status !== void 0 ? _response$status : _timeline.TimelineStatusEnum.active,
        timelineType: (_response$timelineTyp = response.timelineType) !== null && _response$timelineTyp !== void 0 ? _response$timelineTyp : _timeline.TimelineTypeEnum.default,
        templateTimelineId: (_response$templateTim = response.templateTimelineId) !== null && _response$templateTim !== void 0 ? _response$templateTim : null,
        templateTimelineVersion: (_response$templateTim2 = response.templateTimelineVersion) !== null && _response$templateTim2 !== void 0 ? _response$templateTim2 : null,
        savedSearchId: (_response$savedSearch = response.savedSearchId) !== null && _response$savedSearch !== void 0 ? _response$savedSearch : null,
        isSaving: false
      }
    }));
    store.dispatch((0, _actions.setChanged)({
      id: action.payload.id,
      changed: false
    }));
  } catch (error) {
    var _error$message2;
    kibana.notifications.toasts.addDanger({
      title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
      text: (_error$message2 = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message2 !== void 0 ? _error$message2 : i18n.UPDATE_TIMELINE_ERROR_TEXT
    });
  } finally {
    store.dispatch((0, _actions.endTimelineSaving)({
      id: localTimelineId
    }));
  }
};
exports.saveTimelineMiddleware = saveTimelineMiddleware;
const timelineInput = {
  columns: null,
  dataProviders: null,
  dataViewId: null,
  description: null,
  eqlOptions: null,
  eventType: null,
  excludedRowRendererIds: null,
  filters: null,
  kqlMode: null,
  kqlQuery: null,
  indexNames: null,
  title: null,
  timelineType: _timeline.TimelineTypeEnum.default,
  templateTimelineVersion: null,
  templateTimelineId: null,
  dateRange: null,
  savedQueryId: null,
  sort: null,
  status: null,
  savedSearchId: null
};
const convertTimelineAsInput = (timeline, timelineTimeRange) => Object.keys(timelineInput).reduce((acc, key) => {
  if ((0, _fp.has)(key, timeline)) {
    if (key === 'kqlQuery') {
      return (0, _fp2.set)(`${key}.filterQuery`, (0, _fp.get)(`${key}.filterQuery`, timeline), acc);
    } else if (key === 'dateRange') {
      return (0, _fp2.set)(`${key}`, {
        start: timelineTimeRange.from,
        end: timelineTimeRange.to
      }, acc);
    } else if (key === 'columns' && (0, _fp.get)(key, timeline) != null) {
      return (0, _fp2.set)(key, (0, _fp.get)(key, timeline).map(col => (0, _fp.omit)(['initialWidth', 'width', '__typename', 'esTypes'], col)), acc);
    } else if (key === 'filters' && (0, _fp.get)(key, timeline) != null) {
      const filters = (0, _fp.get)(key, timeline);
      return (0, _fp2.set)(key, filters != null ? filters.map(myFilter => {
        const basicFilter = (0, _fp.omit)(['$state'], myFilter);
        return {
          ...basicFilter,
          meta: {
            ...basicFilter.meta,
            field: ((0, _esQuery.isMatchAllFilter)(basicFilter) || (0, _esQuery.isPhraseFilter)(basicFilter) || (0, _esQuery.isPhrasesFilter)(basicFilter) || (0, _esQuery.isRangeFilter)(basicFilter)) && basicFilter.meta.field != null ? convertToString(basicFilter.meta.field) : null,
            value: basicFilter.meta.value != null ? convertToString(basicFilter.meta.value) : null,
            params: basicFilter.meta.params != null ? convertToString(basicFilter.meta.params) : null
          },
          ...((0, _esQuery.isMatchAllFilter)(basicFilter) ? {
            query: {
              match_all: convertToString(basicFilter.query.match_all)
            }
          } : {
            match_all: null
          }),
          ...((0, _esQuery.isExistsFilter)(basicFilter) && basicFilter.query.exists != null ? {
            query: {
              exists: convertToString(basicFilter.query.exists)
            }
          } : {
            exists: null
          }),
          ...(((0, _esQuery.isQueryStringFilter)(basicFilter) || (0, _fp.get)('query', basicFilter) != null) && basicFilter.query != null ? {
            query: convertToString(basicFilter.query)
          } : {
            query: null
          }),
          ...((0, _esQuery.isRangeFilter)(basicFilter) && basicFilter.query.range != null ? {
            query: {
              range: convertToString(basicFilter.query.range)
            }
          } : {
            range: null
          }),
          ...((0, _esQuery.isScriptedRangeFilter)(basicFilter) && basicFilter.query.script != null /* TODO remove it when PR50713 is merged || esFilters.isPhraseFilter(basicFilter) */ ? {
            query: {
              script: convertToString(basicFilter.query.script)
            }
          } : {
            script: null
          })
        };
      }) : [], acc);
    }
    return (0, _fp2.set)(key, (0, _fp.get)(key, timeline), acc);
  }
  return acc;
}, timelineInput);
exports.convertTimelineAsInput = convertTimelineAsInput;
const convertToString = obj => {
  try {
    if ((0, _fp.isObject)(obj)) {
      return JSON.stringify(obj);
    }
    return (0, _fp.toString)(obj);
  } catch {
    return '';
  }
};
function isTimelineErrorResponse(response) {
  return response && ('status_code' in response || 'statusCode' in response);
}
function getErrorFromResponse(response) {
  if ('status_code' in response) {
    return {
      errorCode: response.status_code,
      message: response.message
    };
  } else if ('statusCode' in response) {
    return {
      errorCode: response.statusCode,
      message: response.message
    };
  }
}
function extractTimelineIdsAndVersions(timeline) {
  var _timeline$savedObject;
  // When a timeline hasn't been saved yet, its `savedObectId` is not defined.
  // In that case, we want to overwrite all locally created properties for the
  // timeline id, the timeline template id and the timeline template version.
  return {
    timelineId: (_timeline$savedObject = timeline.savedObjectId) !== null && _timeline$savedObject !== void 0 ? _timeline$savedObject : null,
    timelineVersion: timeline.version,
    templateTimelineId: timeline.savedObjectId ? timeline.templateTimelineId : null,
    templateTimelineVersion: timeline.savedObjectId ? timeline.templateTimelineVersion : null
  };
}