"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIEM_TRANSLATION_RESULT_UNTRANSLATABLE_LABEL = exports.SIEM_TRANSLATION_RESULT_UNKNOWN_LABEL = exports.SIEM_TRANSLATION_RESULT_UNKNOWN_ERROR = exports.SIEM_TRANSLATION_RESULT_PARTIAL_LABEL = exports.SIEM_TRANSLATION_RESULT_FULL_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_TRANSLATION_RESULT_FULL_LABEL = exports.SIEM_TRANSLATION_RESULT_FULL_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationResult.full', {
  defaultMessage: 'Translated'
});
const SIEM_TRANSLATION_RESULT_PARTIAL_LABEL = exports.SIEM_TRANSLATION_RESULT_PARTIAL_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationResult.partially', {
  defaultMessage: 'Partially translated'
});
const SIEM_TRANSLATION_RESULT_UNTRANSLATABLE_LABEL = exports.SIEM_TRANSLATION_RESULT_UNTRANSLATABLE_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationResult.untranslatable', {
  defaultMessage: 'Not translated'
});
const SIEM_TRANSLATION_RESULT_UNKNOWN_LABEL = exports.SIEM_TRANSLATION_RESULT_UNKNOWN_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationResult.unknown', {
  defaultMessage: 'Unknown'
});
const SIEM_TRANSLATION_RESULT_UNKNOWN_ERROR = status => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.translationResult.unknownError', {
    defaultMessage: 'Unknown translation result status: ({status})',
    values: {
      status
    }
  });
};
exports.SIEM_TRANSLATION_RESULT_UNKNOWN_ERROR = SIEM_TRANSLATION_RESULT_UNKNOWN_ERROR;