"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_is_open_state = require("../../../../common/hooks/use_is_open_state");
var _utils = require("../../../../../common/siem_migrations/rules/utils");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _empty_migration = require("./empty_migration");
var _use_migration_rules_table_columns = require("../../hooks/use_migration_rules_table_columns");
var _use_migration_rule_preview_flyout = require("../../hooks/use_migration_rule_preview_flyout");
var _use_install_migration_rule = require("../../logic/use_install_migration_rule");
var _use_install_migration_rules = require("../../logic/use_install_migration_rules");
var _use_get_migration_rules = require("../../logic/use_get_migration_rules");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _use_get_migration_prebuilt_rules = require("../../logic/use_get_migration_prebuilt_rules");
var logicI18n = _interopRequireWildcard(require("../../logic/translations"));
var _bulk_actions = require("./bulk_actions");
var _search_field = require("./search_field");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_start_migration = require("../../service/hooks/use_start_migration");
var _filters = require("./filters");
var _filters2 = require("./utils/filters");
var _translation_guide = require("../tours/translation_guide");
var _start_rule_migration_modal = require("./start_rule_migration_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 10;
const DEFAULT_SORT_FIELD = 'translation_result';
const DEFAULT_SORT_DIRECTION = 'desc';
/**
 * Table Component for displaying SIEM rules migrations
 */
const MigrationRulesTable = exports.MigrationRulesTable = /*#__PURE__*/_react.default.memo(({
  refetchData,
  integrations,
  isIntegrationsLoading,
  migrationStats
}) => {
  var _translationStats$rul;
  const migrationId = migrationStats.id;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const [searchTerm, setSearchTerm] = (0, _react.useState)();

  // Filters
  const [filterOptions, setFilterOptions] = (0, _react.useState)();
  const {
    data: translationStats,
    isLoading: isStatsLoading
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationId);
  const {
    data: prebuiltRules = {},
    isLoading: isPrebuiltRulesLoading
  } = (0, _use_get_migration_prebuilt_rules.useGetMigrationPrebuiltRules)(migrationId);
  const filters = (0, _react.useMemo)(() => ({
    searchTerm,
    ...(0, _filters2.convertFilterOptions)(filterOptions)
  }), [searchTerm, filterOptions]);
  const {
    data: {
      migrationRules,
      total
    } = {
      migrationRules: [],
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_get_migration_rules.useGetMigrationRules)({
    migrationId,
    page: pageIndex,
    perPage: pageSize,
    sortField,
    sortDirection,
    filters
  });
  const [selectedMigrationRules, setSelectedMigrationRules] = (0, _react.useState)([]);
  const tableSelection = (0, _react.useMemo)(() => ({
    selectable: item => {
      var _item$elastic_rule;
      return !((_item$elastic_rule = item.elastic_rule) !== null && _item$elastic_rule !== void 0 && _item$elastic_rule.id) && item.translation_result === _constants.RuleTranslationResult.FULL;
    },
    selectableMessage: (selectable, item) => {
      var _item$elastic_rule2;
      if (selectable) {
        return '';
      }
      return (_item$elastic_rule2 = item.elastic_rule) !== null && _item$elastic_rule2 !== void 0 && _item$elastic_rule2.id ? i18n.ALREADY_TRANSLATED_RULE_TOOLTIP : i18n.NOT_FULLY_TRANSLATED_RULE_TOOLTIP;
    },
    onSelectionChange: setSelectedMigrationRules,
    selected: selectedMigrationRules
  }), [selectedMigrationRules]);
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      pageSize,
      totalItemCount: total
    };
  }, [pageIndex, pageSize, total]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortDirection, sortField]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const handleOnSearch = (0, _react.useCallback)(value => {
    setSearchTerm(value.trim());
  }, []);
  const {
    mutateAsync: installMigrationRule
  } = (0, _use_install_migration_rule.useInstallMigrationRule)(migrationId);
  const {
    mutateAsync: installMigrationRules
  } = (0, _use_install_migration_rules.useInstallMigrationRules)(migrationId, translationStats);
  const {
    startMigration,
    isLoading: isRetryLoading
  } = (0, _use_start_migration.useStartMigration)(refetchData);
  const [isTableLoading, setTableLoading] = (0, _react.useState)(false);
  const installSingleRule = (0, _react.useCallback)(async (migrationRule, enabled) => {
    setTableLoading(true);
    try {
      await installMigrationRule({
        migrationRule,
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [addError, installMigrationRule]);
  const installSelectedRule = (0, _react.useCallback)(async enabled => {
    setTableLoading(true);
    try {
      await installMigrationRules({
        ids: selectedMigrationRules.map(rule => rule.id),
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
      setSelectedMigrationRules([]);
    }
  }, [addError, installMigrationRules, selectedMigrationRules]);
  const installTranslatedRules = (0, _react.useCallback)(async enabled => {
    setTableLoading(true);
    try {
      await installMigrationRules({
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [addError, installMigrationRules]);
  const reprocessFailedRulesWithSettings = (0, _react.useCallback)(settings => {
    startMigration(migrationId, _constants.SiemMigrationRetryFilter.FAILED, settings);
  }, [migrationId, startMigration]);
  const defaultSettingsForModal = (0, _react.useMemo)(() => {
    var _migrationStats$last_, _migrationStats$last_2;
    return {
      connectorId: migrationStats === null || migrationStats === void 0 ? void 0 : (_migrationStats$last_ = migrationStats.last_execution) === null || _migrationStats$last_ === void 0 ? void 0 : _migrationStats$last_.connector_id,
      skipPrebuiltRulesMatching: migrationStats === null || migrationStats === void 0 ? void 0 : (_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.skip_prebuilt_rules_matching
    };
  }, [migrationStats.last_execution]);
  const {
    isOpen: isReprocessFailedRulesModalVisible,
    open: showReprocessFailedRulesModal,
    close: closeReprocessFailedRulesModal
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const isRulesLoading = isPrebuiltRulesLoading || isDataLoading || isTableLoading || isRetryLoading;
  const ruleActionsFactory = (0, _react.useCallback)((migrationRule, closeRulePreview) => {
    var _migrationRule$elasti;
    const canMigrationRuleBeInstalled = !isRulesLoading && !((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id) && migrationRule.translation_result === _constants.RuleTranslationResult.FULL;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canMigrationRuleBeInstalled,
      onClick: () => {
        installSingleRule(migrationRule);
        closeRulePreview();
      },
      "data-test-subj": "installMigrationRuleFromFlyoutButton"
    }, i18n.INSTALL_WITHOUT_ENABLING_BUTTON_LABEL)), (0, _utils.isMigrationPrebuiltRule)(migrationRule.elastic_rule) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canMigrationRuleBeInstalled,
      onClick: () => {
        installSingleRule(migrationRule, true);
        closeRulePreview();
      },
      fill: true,
      "data-test-subj": "installAndEnableMigrationRuleFromFlyoutButton"
    }, i18n.INSTALL_AND_ENABLE_BUTTON_LABEL)));
  }, [installSingleRule, isRulesLoading]);
  const getMigrationRuleData = (0, _react.useCallback)(ruleId => {
    if (!isRulesLoading && migrationRules.length) {
      const migrationRule = migrationRules.find(item => item.id === ruleId);
      let matchedPrebuiltRule;
      let relatedIntegrations = [];
      if (migrationRule) {
        var _migrationRule$elasti2, _prebuiltRuleVersions, _migrationRule$elasti3;
        // Find matched prebuilt rule if any and prioritize its installed version
        const prebuiltRuleId = (_migrationRule$elasti2 = migrationRule.elastic_rule) === null || _migrationRule$elasti2 === void 0 ? void 0 : _migrationRule$elasti2.prebuilt_rule_id;
        const prebuiltRuleVersions = prebuiltRuleId ? prebuiltRules[prebuiltRuleId] : undefined;
        matchedPrebuiltRule = (_prebuiltRuleVersions = prebuiltRuleVersions === null || prebuiltRuleVersions === void 0 ? void 0 : prebuiltRuleVersions.current) !== null && _prebuiltRuleVersions !== void 0 ? _prebuiltRuleVersions : prebuiltRuleVersions === null || prebuiltRuleVersions === void 0 ? void 0 : prebuiltRuleVersions.target;
        const integrationIds = (_migrationRule$elasti3 = migrationRule.elastic_rule) === null || _migrationRule$elasti3 === void 0 ? void 0 : _migrationRule$elasti3.integration_ids;
        if (integrations && integrationIds) {
          relatedIntegrations = integrationIds.map(integrationId => integrations[integrationId]).filter(integration => integration != null);
        }
      }
      return {
        migrationRule,
        matchedPrebuiltRule,
        relatedIntegrations,
        isIntegrationsLoading
      };
    }
  }, [integrations, isIntegrationsLoading, isRulesLoading, prebuiltRules, migrationRules]);
  const {
    migrationRuleDetailsFlyout: rulePreviewFlyout,
    openMigrationRuleDetails: openRulePreview
  } = (0, _use_migration_rule_preview_flyout.useMigrationRuleDetailsFlyout)({
    isLoading: isRulesLoading,
    getMigrationRuleData,
    ruleActionsFactory
  });
  const rulesColumns = (0, _use_migration_rules_table_columns.useMigrationRulesTableColumns)({
    disableActions: isTableLoading,
    openMigrationRuleDetails: openRulePreview,
    installMigrationRule: installSingleRule,
    getMigrationRuleData
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReprocessFailedRulesModalVisible && /*#__PURE__*/_react.default.createElement(_start_rule_migration_modal.StartRuleMigrationModal, {
    defaultSettings: defaultSettingsForModal,
    onStartMigrationWithSettings: reprocessFailedRulesWithSettings,
    onClose: closeReprocessFailedRulesModal,
    numberOfRules: (_translationStats$rul = translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.failed) !== null && _translationStats$rul !== void 0 ? _translationStats$rul : 0
  }), !isStatsLoading && (translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.total) && /*#__PURE__*/_react.default.createElement(_translation_guide.SiemTranslatedRulesTour, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isStatsLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: !(translationStats !== null && translationStats !== void 0 && translationStats.rules.total) ? /*#__PURE__*/_react.default.createElement(_empty_migration.EmptyMigration, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "siemMigrationsRulesTable",
      gutterSize: "m",
      justifyContent: "flexEnd",
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_field.SearchField, {
      initialValue: searchTerm,
      onSearch: handleOnSearch
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_filters.MigrationRulesFilter, {
      filterOptions: filterOptions,
      onFilterOptionsChanged: setFilterOptions
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_bulk_actions.BulkActions, {
      isTableLoading: isRulesLoading,
      numberOfFailedRules: translationStats.rules.failed,
      numberOfTranslatedRules: translationStats.rules.success.installable,
      numberOfSelectedRules: selectedMigrationRules.length,
      installTranslatedRule: installTranslatedRules,
      installSelectedRule: installSelectedRule,
      reprocessFailedRules: showReprocessFailedRulesModal
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: isTableLoading,
      items: migrationRules,
      pagination: pagination,
      sorting: sorting,
      onChange: onTableChange,
      selection: tableSelection,
      itemId: 'id',
      "data-test-subj": 'rules-translation-table',
      columns: rulesColumns
    }))
  }), rulePreviewFlyout);
});
MigrationRulesTable.displayName = 'MigrationRulesTable';