"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetActionState = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/endpoint/constants");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get info for action state
 */
const useGetActionState = () => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-action-state'],
    queryFn: () => {
      return http.get(_constants.ACTION_STATE_ROUTE, {
        version: '2023-10-31'
      });
    }
  });
};
exports.useGetActionState = useGetActionState;