"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDocumentTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _json_tab = require("../../../document_details/right/tabs/json_tab");
var _table_tab = require("../../../document_details/right/tabs/table_tab");
var _test_ids = require("./test_ids");
var _flyout_body = require("../../../shared/components/flyout_body");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: _test_ids.TABLE_TAB_TEST_ID,
  'data-test-subj': _test_ids.TABLE_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.userDetails.tableTabLabel",
    defaultMessage: "Table"
  }),
  content: /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, null)
}, {
  id: _test_ids.JSON_TAB_TEST_ID,
  'data-test-subj': _test_ids.JSON_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.userDetails.jsonTabLabel",
    defaultMessage: "JSON"
  }),
  content: /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, null)
}];
const useFilterOptions = () => (0, _react.useMemo)(() => tabs.map(tab => {
  return {
    id: tab.id,
    label: tab.name
  };
}), []);
const AssetDocumentTab = exports.AssetDocumentTab = /*#__PURE__*/(0, _react.memo)(() => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const buttonButtons = useFilterOptions();
  const selectedTab = (0, _react.useMemo)(() => {
    return tabs.find(tab => tab.id === selectedTabId);
  }, [selectedTabId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.userDetails.tabsLegend', {
      defaultMessage: 'Asset document tabs'
    }),
    options: buttonButtons,
    idSelected: selectedTabId,
    onChange: setSelectedTabId,
    buttonSize: "compressed",
    isFullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    "data-test-subj": _test_ids.FLYOUT_BODY_TEST_ID
  }, selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.content));
});
AssetDocumentTab.displayName = 'AssetDocumentLeftPanel';