"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedUser = void 0;
var _react = require("react");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_integrations = require("../../../../detection_engine/common/components/related_integrations/use_integrations");
var _search_strategy = require("../../../../../common/api/search_strategy");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _manage_query = require("../../../../common/components/page/manage_query");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packages = [_constants.ENTRA_ID_PACKAGE_NAME, _constants.OKTA_PACKAGE_NAME];
const useManagedUser = (userName, email, isLoading) => {
  const skip = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyoutManagedUser');
  const {
    to,
    from,
    isInitializing,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    loading: loadingManagedUser,
    result: {
      users: managedUserData
    },
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.UsersQueries.managedDetails,
    initialResult: {
      users: {}
    },
    errorMessage: i18n.FAIL_MANAGED_USER
  });
  const defaultIndex = (0, _react.useMemo)(() => spaceId ? [(0, _constants.getEntraUserIndex)(spaceId), (0, _constants.getOktaUserIndex)(spaceId)] : [], [spaceId]);
  (0, _react.useEffect)(() => {
    if (!isInitializing && defaultIndex.length > 0 && !isLoading && userName && !skip) {
      search({
        defaultIndex,
        userEmail: email,
        userName
      });
    }
  }, [from, search, to, isInitializing, defaultIndex, userName, isLoading, email, skip]);
  const {
    data: integrations,
    isLoading: loadingIntegrations
  } = (0, _use_integrations.useIntegrations)({
    skip
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _constants.MANAGED_USER_QUERY_ID,
    loading: loadingManagedUser
  });
  const isIntegrationEnabled = (0, _react.useMemo)(() => !!(integrations !== null && integrations !== void 0 && integrations.some(({
    package_name: packageName,
    is_enabled: isEnabled
  }) => isEnabled && packages.includes(packageName))), [integrations]);
  return (0, _react.useMemo)(() => ({
    data: managedUserData,
    isLoading: skip ? false : loadingManagedUser || loadingIntegrations,
    isIntegrationEnabled
  }), [isIntegrationEnabled, loadingIntegrations, loadingManagedUser, managedUserData, skip]);
};
exports.useManagedUser = useManagedUser;