"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetGenericEntity = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _constants = require("../../../../asset_inventory/constants");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchGenericEntity = async (dataService, docId) => {
  return (0, _rxjs.lastValueFrom)(dataService.search.search({
    params: {
      index: _constants.ASSET_INVENTORY_INDEX_PATTERN,
      query: {
        term: {
          _id: docId
        }
      }
    }
  }));
};
const useGetGenericEntity = docId => {
  const {
    data: dataService
  } = (0, _kibana.useKibana)().services;
  const getGenericEntity = (0, _reactQuery.useQuery)({
    queryKey: ['use-get-generic-entity-key', docId],
    queryFn: () => fetchGenericEntity(dataService, docId),
    select: response => response.rawResponse.hits.hits[0] // extracting result out of ES
  });
  return {
    getGenericEntity
  };
};
exports.useGetGenericEntity = useGetGenericEntity;