"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEntityIconByType = exports.GenericEntityFlyoutHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _header_data_cards = require("./header_data_cards");
var _expandable_badge_group = require("./components/expandable_badge_group");
var _helpers = require("../../../entity_analytics/components/entity_store/helpers");
var _formatted_date = require("../../../common/components/formatted_date");
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_title = require("../../shared/components/flyout_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialBadgeLimit = 3;
const maxBadgeContainerHeight = 200;
const HeaderTags = ({
  tags = [],
  labels = {}
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tagBadges = (0, _react.useMemo)(() => tags === null || tags === void 0 ? void 0 : tags.map(tag => ({
    color: 'hollow',
    children: tag
  })), [tags]);
  const labelBadges = (0, _react.useMemo)(() => {
    var _Object$entries;
    return labels && ((_Object$entries = Object.entries(labels)) === null || _Object$entries === void 0 ? void 0 : _Object$entries.map(([key, value]) => ({
      color: 'hollow',
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
                color: ${euiTheme.colors.textDisabled};
                border-right: ${euiTheme.border.thick};
                padding-right: ${euiTheme.size.xs};
              `
      }, key), /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
                padding-left: ${euiTheme.size.xs};
              `
      }, value))
    })));
  }, [labels, euiTheme.colors.textDisabled, euiTheme.border.thick, euiTheme.size.xs]);
  const allBadges = [...(tagBadges || []), ...(labelBadges || [])];
  return /*#__PURE__*/_react.default.createElement(_expandable_badge_group.ExpandableBadgeGroup, {
    badges: allBadges,
    initialBadgeLimit: initialBadgeLimit,
    maxHeight: maxBadgeContainerHeight
  });
};
// TODO: Asset Inventory - move this to a shared location, for now it's here as a mock since we dont have generic entities yet
var GenericEntityType = /*#__PURE__*/function (GenericEntityType) {
  GenericEntityType["container"] = "container";
  return GenericEntityType;
}(GenericEntityType || {});
const GenericEntityIconByType = exports.GenericEntityIconByType = {
  ..._helpers.EntityIconByType,
  container: 'container'
};
const isDate = value => value instanceof Date;
const GenericEntityFlyoutHeader = ({
  entity,
  source
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const docTimestamp = source === null || source === void 0 ? void 0 : source['@timestamp'];
  const timestamp = isDate(docTimestamp) ? docTimestamp : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: "column"
  }, timestamp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: timestamp
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: entity === null || entity === void 0 ? void 0 : entity.name,
    iconType: GenericEntityIconByType[entity === null || entity === void 0 ? void 0 : entity.type] || 'globe',
    iconColor: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.s};
            `
  }, (source.tags || source.labels) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(HeaderTags, {
    tags: source.tags,
    labels: source.labels
  }))), /*#__PURE__*/_react.default.createElement(_header_data_cards.HeaderDataCards, {
    id: entity.id,
    type: entity.type,
    subType: entity.sub_type
  }))));
};
exports.GenericEntityFlyoutHeader = GenericEntityFlyoutHeader;