"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_non_closed_alerts = require("../../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _user_overview = require("../../../../overview/components/user_overview");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _inspect = require("../../../../common/components/inspect");
var _types = require("../../../../../common/entity_analytics/types");
var _common = require("../../../../entity_analytics/components/severity/common");
var _default_renderer = require("../../../../timelines/components/field_renderers/default_renderer");
var _cell_actions = require("../../shared/components/cell_actions");
var _constants = require("../../../../common/store/inputs/constants");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _containers = require("../../../../sourcerer/containers");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _actions = require("../../../../common/store/inputs/actions");
var _host_to_criteria = require("../../../../common/components/ml/criteria/host_to_criteria");
var _manage_query = require("../../../../common/components/page/manage_query");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _related_hosts = require("../../../../common/containers/related_entities/related_hosts");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_value = require("../../../../common/components/empty_value");
var _test_ids = require("./test_ids");
var _constants2 = require("../../../../timelines/components/timeline/body/renderers/constants");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../../../../entity_analytics/components/risk_score/translations");
var _helper_hooks = require("../../../../helper_hooks");
var _user_right = require("../../../entity_details/user_right");
var _user_entity_overview = require("../../right/components/user_entity_overview");
var _preview_link = require("../../../shared/components/preview_link");
var _misconfiguration_insight = require("../../shared/components/misconfiguration_insight");
var _alert_count_insight = require("../../shared/components/alert_count_insight");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_navigate_to_user_details = require("../../../entity_details/user_right/hooks/use_navigate_to_user_details");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_DETAILS_ID = 'entities-users-details';
const RELATED_HOSTS_ID = 'entities-users-related-hosts';
const USER_DETAILS_INSIGHTS_ID = 'user-details-insights';
const UserOverviewManage = (0, _manage_query.manageQuery)(_user_overview.UserOverview);
const RelatedHostsManage = (0, _manage_query.manageQuery)(_inspect.InspectButtonContainer);
/**
 * User details and related users, displayed in the document details expandable flyout left section under the Insights tab, Entities tab
 */
const UserDetails = ({
  userName,
  timestamp,
  scopeId
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  // create a unique, but stable (across re-renders) query id
  const userDetailsQueryId = (0, _react.useMemo)(() => `${USER_DETAILS_ID}-${(0, _uuid.v4)()}`, []);
  const relatedHostsQueryId = (0, _react.useMemo)(() => `${RELATED_HOSTS_ID}-${(0, _uuid.v4)()}`, []);
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const isEntityAnalyticsAuthorized = isPlatinumOrTrialLicense && hasEntityAnalyticsCapability;
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const openUserPreview = (0, _react.useCallback)(() => {
    openPreviewPanel({
      id: _user_right.UserPreviewPanelKey,
      params: {
        userName,
        scopeId,
        banner: _user_entity_overview.USER_PREVIEW_BANNER
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'preview'
    });
  }, [openPreviewPanel, userName, scopeId, telemetry]);
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const {
    data: userRisk
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _types.EntityType.user,
    timerange
  });
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  const isRiskScoreExist = !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk);
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(_types.EntityIdentifierFields.userName, userName);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types.EntityIdentifierFields.userName,
    value: userName,
    to,
    from,
    queryId: USER_DETAILS_INSIGHTS_ID
  });
  const {
    openDetailsPanel
  } = (0, _use_navigate_to_user_details.useNavigateToUserDetails)({
    userName,
    scopeId,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasNonClosedAlerts,
    isPreviewMode: true,
    // setting to true to always open a new user flyout
    contextID: USER_DETAILS_INSIGHTS_ID
  });
  const [isUserLoading, {
    inspect,
    userDetails,
    refetch
  }] = (0, _observed_details.useObservedUserDetails)({
    id: userDetailsQueryId,
    startDate: from,
    endDate: to,
    userName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const {
    loading: isRelatedHostLoading,
    inspect: inspectRelatedHosts,
    relatedHosts,
    totalCount,
    refetch: refetchRelatedHosts
  } = (0, _related_hosts.useUserRelatedHosts)({
    userName,
    indexNames: selectedPatterns,
    from: timestamp,
    // related hosts are hosts this user has successfully authenticated onto AFTER alert time
    skip: selectedPatterns.length === 0
  });
  const relatedHostsColumns = (0, _react.useMemo)(() => [{
    field: 'host',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsNameColumnLabel",
      defaultMessage: "Name"
    }),
    render: host => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: _constants2.HOST_NAME_FIELD_NAME,
      value: host
    }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: _constants2.HOST_NAME_FIELD_NAME,
      value: host,
      scopeId: scopeId,
      "data-test-subj": _test_ids.USER_DETAILS_RELATED_HOSTS_LINK_TEST_ID
    })))
  }, {
    field: 'ip',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsIpColumnLabel",
      defaultMessage: "Ip addresses"
    }),
    render: ips => {
      return /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
        rowItems: ips,
        attrName: _constants2.HOST_IP_FIELD_NAME,
        idPrefix: '',
        render: ip => ip == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
          field: _constants2.HOST_IP_FIELD_NAME,
          value: ip,
          scopeId: scopeId,
          "data-test-subj": _test_ids.USER_DETAILS_RELATED_HOSTS_IP_LINK_TEST_ID
        }),
        scopeId: scopeId
      });
    }
  }, ...(isEntityAnalyticsAuthorized ? [{
    field: 'risk',
    name: (0, _translations.ENTITY_RISK_LEVEL)(_types.EntityType.host),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: riskScore => {
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: riskScore
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }] : [])], [isEntityAnalyticsAuthorized, scopeId]);
  const relatedHostsCount = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "storage"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsCountLabel",
    defaultMessage: "Related hosts: {count}",
    values: {
      count: totalCount
    }
  }))))), [totalCount]);
  const pagination = {
    pageSize: 4,
    showPerPageOptions: false
  };
  const userLink = (0, _react.useMemo)(() => ({
    callback: openUserPreview,
    tooltip: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.entities.user.userPreviewTitle', {
      defaultMessage: 'Preview user'
    })
  }), [openUserPreview]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.userDetailsTitle",
    defaultMessage: "User"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: userName,
      iconType: 'user',
      headerContent: relatedHostsCount,
      link: userLink
    },
    expand: {
      expandable: true,
      expandedOnFirstRender: true
    },
    "data-test-subj": _test_ids.USER_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.userDetailsInfoTitle",
    defaultMessage: "User information"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(userDetails),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(UserOverviewManage, {
    id: userDetailsQueryId,
    isInDetailsSidePanel: false,
    data: userDetails,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: isUserLoading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    userName: userName,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById,
    scopeId: scopeId,
    isFlyoutOpen: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    responsive: false,
    columns: 3,
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_alert_count_insight.AlertCountInsight, {
    fieldName: 'user.name',
    name: userName,
    direction: "column",
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.USER_DETAILS_ALERT_COUNT_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_misconfiguration_insight.MisconfigurationsInsight, {
    fieldName: 'user.name',
    name: userName,
    direction: "column",
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.USER_DETAILS_MISCONFIGURATIONS_TEST_ID,
    telemetryKey: _ui_metrics.MISCONFIGURATION_INSIGHT_USER_DETAILS
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsTitle",
    defaultMessage: "Related hosts"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsTooltip",
      defaultMessage: "After this event, {userName} logged into these hosts. Check if this activity is normal.",
      values: {
        userName
      }
    }),
    type: "info",
    className: "eui-alignTop"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RelatedHostsManage, {
    id: relatedHostsQueryId,
    inspect: inspectRelatedHosts,
    loading: isRelatedHostLoading,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    refetch: refetchRelatedHosts
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: relatedHostsColumns,
    items: relatedHosts,
    loading: isRelatedHostLoading,
    "data-test-subj": _test_ids.USER_DETAILS_RELATED_HOSTS_TABLE_TEST_ID,
    pagination: pagination,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsNoDataDescription",
      defaultMessage: "No hosts identified"
    })
  }), /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: relatedHostsQueryId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedHostsInspectButtonTitle",
      defaultMessage: "Related hosts"
    }),
    inspectIndex: 0
  })))));
};
exports.UserDetails = UserDetails;