"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _threat_intelligence = require("../../shared/utils/threat_intelligence");
var _constants = require("../../../../../common/cti/constants");
var _threat_details_view_enrichment_accordion_group = require("./threat_details_view_enrichment_accordion_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDICATOR_ENRICHMENT_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.indicatorEnrichmentTitle', {
  defaultMessage: 'Threat match detected'
});
const INVESTIGATION_ENRICHMENT_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.investigationEnrichmentTitle', {
  defaultMessage: 'Enriched with threat intelligence'
});
const INDICATOR_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.indicatorEnrichmentTooltipContent', {
  defaultMessage: 'Shows available threat indicator matches.'
});
const INVESTIGATION_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.investigationEnrichmentTooltipContent', {
  defaultMessage: 'Shows additional threat intelligence for the alert. The past 30 days were queried by default.'
});
const NO_ENRICHMENTS_FOUND_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.noEnrichmentsFoundDescription', {
  defaultMessage: 'This alert does not have threat intelligence.'
});
const InlineBlock = _styledComponents.default.div`
  display: inline-block;
  line-height: 1.7em;
`;
/**
 * Displays the enrichments in multiple accordions when data has loaded.
 * While data is loading, it renders a skeleton.
 * If no data is found, it displays a message.
 * Also allows to render a component passed from the parent (currently used to render a range picker).
 */
const EnrichmentSection = exports.EnrichmentSection = /*#__PURE__*/(0, _react.memo)(({
  enrichments,
  type,
  loading,
  dataTestSubj,
  children
}) => {
  const tooltip = (0, _react.useMemo)(() => (0, _threat_intelligence.isInvestigationTimeEnrichment)(type) ? INVESTIGATION_TOOLTIP_CONTENT : INDICATOR_TOOLTIP_CONTENT, [type]);
  const noEnrichmentDataMessage = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(InlineBlock, {
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_NO_ENRICHMENTS_FOUND_TEST_ID
  }, type === _constants.ENRICHMENT_TYPES.IndicatorMatchRule ? NO_ENRICHMENTS_FOUND_DESCRIPTION : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.enrichment.noInvestigationEnrichment",
    defaultMessage: "Additional threat intelligence wasn't found within the selected time frame. Try a different time frame, or {link} to collect threat intelligence for threat detection and matching.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.enrichment.investigationEnrichmentDocumentationLink",
        defaultMessage: "enable threat intelligence integrations"
      }))
    }
  })), [type]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, type ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "baseline",
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, type === _constants.ENRICHMENT_TYPES.IndicatorMatchRule ? INDICATOR_ENRICHMENT_TITLE : INVESTIGATION_ENRICHMENT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltip,
    type: "info",
    size: "m"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, children, Array.isArray(enrichments) ? /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_accordion_group.EnrichmentAccordionGroup, {
    enrichments: enrichments
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type ? noEnrichmentDataMessage : null, loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_LOADING_ENRICHMENTS_TEST_ID,
    lines: 4
  }))));
});
EnrichmentSection.displayName = 'EnrichmentSection';