"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _ = require("../app/404");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _constants = require("../../common/constants");
var _entity_analytics_management_page = require("./pages/entity_analytics_management_page");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_store_management_page = require("./pages/entity_store_management_page");
var _entity_analytics_landing = require("./pages/entity_analytics_landing");
var _entity_analytics_privileged_user_monitoring_page = require("./pages/entity_analytics_privileged_user_monitoring_page");
var _entity_analytics_overview_page = require("./pages/entity_analytics_overview_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsManagementWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_management_page.EntityAnalyticsManagementPage, null));
const EntityAnalyticsManagementContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsManagementWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsManagementContainer.displayName = 'EntityAnalyticsManagementContainer';
const EntityAnalyticsAssetClassificationContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
    exact: true,
    render: ({
      location
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        ...location,
        pathname: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
        search: location.search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsAssetClassificationContainer.displayName = 'EntityAnalyticsAssetClassificationContainer';
const EntityAnalyticsEntityStoreWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_store_management_page.EntityStoreManagementPage, null));
const EntityAnalyticsEntityStoreContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsEntityStoreWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsEntityStoreContainer.displayName = 'EntityAnalyticsEntityStoreContainer';
const EntityAnalyticsLandingWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_landing.EntityAnalyticsLandingPage, null));
const EntityAnalyticsLandingContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
    exact: true,
    component: EntityAnalyticsLandingWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsLandingContainer.displayName = 'EntityAnalyticsLandingContainer';
const EntityAnalyticsPrivilegedUserMonitoringWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_privileged_user_monitoring_page.EntityAnalyticsPrivilegedUserMonitoringPage, null));
const EntityAnalyticsPrivilegedUserMonitoringContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
    exact: true,
    component: EntityAnalyticsPrivilegedUserMonitoringWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsPrivilegedUserMonitoringContainer.displayName = 'EntityAnalyticsPrivilegedUserMonitoringContainer';
const EntityAnalyticsOverviewWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_overview_page.OverviewDashboard, null));
const EntityAnalyticsOverviewContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
    exact: true,
    component: EntityAnalyticsOverviewWrapper
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
});
EntityAnalyticsOverviewContainer.displayName = 'EntityAnalyticsOverviewContainer';
const routes = exports.routes = [{
  path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsManagementContainer, _constants.SecurityPageName.entityAnalyticsManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
  component: EntityAnalyticsAssetClassificationContainer
}, {
  path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsEntityStoreContainer, _constants.SecurityPageName.entityAnalyticsEntityStoreManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsLandingContainer, _constants.SecurityPageName.entityAnalyticsLanding)
}, {
  path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsPrivilegedUserMonitoringContainer, _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring)
}, {
  path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsOverviewContainer, _constants.SecurityPageName.entityAnalyticsOverview)
}];