"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvUploadManageDataSource = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHooks = require("@kbn/react-hooks");
var _manage_data_sources_query_hooks = require("./hooks/manage_data_sources_query_hooks");
var _file_uploader = require("../privileged_user_monitoring_onboarding/components/file_uploader");
var _formatted_date = require("../../../common/components/formatted_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CsvUploadManageDataSource = ({
  setAddDataSourceResult,
  namespace
}) => {
  const [isImportFileModalVisible, {
    on: showImportFileModal,
    off: closeImportFileModal
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    latestTimestamp,
    isLoading,
    isError,
    refetch
  } = (0, _manage_data_sources_query_hooks.useGetLatestCSVPrivilegedUserUploadQuery)(namespace);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "importAction"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.file",
    defaultMessage: "File"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.file.text",
    defaultMessage: "Import a CSV file exported from your user management tool. Uploading a new file will overwrite any users added from a previous file."
  })), isError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.file.retrievalError",
      defaultMessage: "There was an error retrieving previous CSV uploads."
    }),
    color: "danger"
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }), !isLoading && !isError && !latestTimestamp && /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.file.noFilesAdded",
    defaultMessage: "No files added"
  })), latestTimestamp && /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.file.lastUpdatedTimestamp",
    defaultMessage: "Last uploaded: "
  }), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(latestTimestamp)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isError || isLoading,
    onClick: showImportFileModal,
    fullWidth: false,
    iconType: "plusInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.indices.text",
    defaultMessage: "Import file"
  }))), isImportFileModalVisible && /*#__PURE__*/_react.default.createElement(_file_uploader.UploadPrivilegedUsersModal, {
    onClose: closeImportFileModal,
    onImport: async userCount => {
      closeImportFileModal();
      setAddDataSourceResult({
        successful: true,
        userCount
      });
      await refetch();
    }
  }));
};
exports.CsvUploadManageDataSource = CsvUploadManageDataSource;