"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggleOptions = exports.useStackByOptions = exports.usePrivilegedUserActivityParams = exports.useDiscoverUrl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _rison = require("@kbn/rison");
var _kibana = require("../../../../../common/lib/kibana");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_space_id = require("../../../../../common/hooks/use_space_id");
var _esql_data_generation = require("../../../privileged_user_monitoring_onboarding/components/sample_dashboard/esql_data_generation");
var _types = require("./types");
var _columns = require("./columns");
var _get_lens_attributes = require("./get_lens_attributes");
var _constants = require("./constants");
var _authentications_esql_query = require("../../queries/authentications_esql_query");
var _account_switches_esql_query = require("../../queries/account_switches_esql_query");
var _granted_rights_esql_query = require("../../queries/granted_rights_esql_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverUrl = ({
  generateTableQuery
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useNavigation)();
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const discoverUrl = (0, _react.useMemo)(() => {
    if (!generateTableQuery) return {
      discoverUrl: ''
    };
    const query = generateTableQuery('@timestamp', 'DESC', 100);
    const appState = {
      query: {
        esql: query
      }
    };
    let discoverAppPath;
    try {
      const encodedAppState = (0, _rison.encode)(appState);
      discoverAppPath = `#/?_a=${encodedAppState}`;
    } catch (error) {
      addWarning(error, {
        title: _constants.ERROR_ENCODING_ESQL_QUERY
      });
      discoverAppPath = '#/';
    }
    return {
      discoverUrl: getAppUrl({
        appId: 'discover',
        path: discoverAppPath
      })
    };
  }, [generateTableQuery, getAppUrl, addWarning]);
  return discoverUrl;
};
exports.useDiscoverUrl = useDiscoverUrl;
const toggleOptionsConfig = {
  [_types.VisualizationToggleOptions.GRANTED_RIGHTS]: {
    generateEsqlSource: _granted_rights_esql_query.getGrantedRightsEsqlSource,
    buildColumns: _columns.buildGrantedRightsColumns,
    stackByOptions: _constants.GRANTED_RIGHTS_STACK_BY
  },
  [_types.VisualizationToggleOptions.ACCOUNT_SWITCHES]: {
    generateEsqlSource: _account_switches_esql_query.getAccountSwitchesEsqlSource,
    buildColumns: _columns.buildAccountSwitchesColumns,
    stackByOptions: _constants.ACCOUNT_SWITCH_STACK_BY
  },
  [_types.VisualizationToggleOptions.AUTHENTICATIONS]: {
    generateEsqlSource: _authentications_esql_query.getAuthenticationsEsqlSource,
    buildColumns: _columns.buildAuthenticationsColumns,
    stackByOptions: _constants.AUTHENTICATIONS_STACK_BY
  }
};
const usePrivilegedUserActivityParams = (selectedToggleOption, sourcererDataView) => {
  var _sourcererDataView$ti;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const indexPattern = (_sourcererDataView$ti = sourcererDataView === null || sourcererDataView === void 0 ? void 0 : sourcererDataView.title) !== null && _sourcererDataView$ti !== void 0 ? _sourcererDataView$ti : '';
  const fields = sourcererDataView === null || sourcererDataView === void 0 ? void 0 : sourcererDataView.fields;
  const esqlSource = (0, _react.useMemo)(() => spaceId && indexPattern && fields ? toggleOptionsConfig[selectedToggleOption].generateEsqlSource(spaceId, indexPattern, fields) : undefined, [selectedToggleOption, spaceId, indexPattern, fields]);
  const generateTableQuery = (0, _react.useMemo)(() => esqlSource ? (0, _esql_data_generation.generateListESQLQuery)(esqlSource) : undefined, [esqlSource]);
  const generateVisualizationQuery = (0, _react.useMemo)(() => esqlSource ? (0, _esql_data_generation.generateVisualizationESQLQuery)(esqlSource) : undefined, [esqlSource]);
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const columns = (0, _react.useMemo)(() => toggleOptionsConfig[selectedToggleOption].buildColumns(openRightPanel), [selectedToggleOption, openRightPanel]);
  const hasLoadedDependencies = (0, _react.useMemo)(() => Boolean(spaceId && indexPattern && fields), [spaceId, indexPattern, fields]);
  return {
    getLensAttributes: _get_lens_attributes.getLensAttributes,
    generateVisualizationQuery,
    generateTableQuery,
    columns,
    hasLoadedDependencies
  };
};
exports.usePrivilegedUserActivityParams = usePrivilegedUserActivityParams;
const useToggleOptions = () => (0, _react.useMemo)(() => [{
  id: _types.VisualizationToggleOptions.GRANTED_RIGHTS,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.grantedRights",
    defaultMessage: "Granted rights"
  })
}, {
  id: _types.VisualizationToggleOptions.ACCOUNT_SWITCHES,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.accountSwitches",
    defaultMessage: "Account switches"
  })
}, {
  id: _types.VisualizationToggleOptions.AUTHENTICATIONS,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.authentications",
    defaultMessage: "Authentications"
  })
}], []);
exports.useToggleOptions = useToggleOptions;
const useStackByOptions = selectedToggleOption => toggleOptionsConfig[selectedToggleOption].stackByOptions;
exports.useStackByOptions = useStackByOptions;