"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonRuleFieldEdit = CommonRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _field_final_side = require("../field_final_side");
var _building_block = require("./fields/building_block");
var _description = require("./fields/description");
var _false_positives = require("./fields/false_positives");
var _investigation_fields = require("./fields/investigation_fields");
var _max_signals = require("./fields/max_signals");
var _name = require("./fields/name");
var _note = require("./fields/note");
var _references = require("./fields/references");
var _related_integrations = require("./fields/related_integrations");
var _required_fields = require("./fields/required_fields");
var _risk_score = require("./fields/risk_score");
var _risk_score_mapping = require("./fields/risk_score_mapping");
var _rule_name_override = require("./fields/rule_name_override");
var _setup = require("./fields/setup");
var _severity = require("./fields/severity");
var _severity_mapping = require("./fields/severity_mapping");
var _tags = require("./fields/tags");
var _threat = require("./fields/threat");
var _timeline_template = require("./fields/timeline_template");
var _timestamp_override = require("./fields/timestamp_override");
var _rule_schedule = require("./fields/rule_schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable-next-line complexity */
function CommonRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'building_block':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _building_block.BuildingBlockEdit,
        ruleFieldFormSchema: _building_block.buildingBlockSchema,
        serializer: _building_block.buildingBlockSerializer,
        deserializer: _building_block.buildingBlockDeserializer
      });
    case 'description':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _description.DescriptionEdit,
        ruleFieldFormSchema: _description.descriptionSchema
      });
    case 'false_positives':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _false_positives.FalsePositivesEdit,
        ruleFieldFormSchema: _false_positives.falsePositivesSchema,
        serializer: _false_positives.falsePositivesSerializer,
        deserializer: _false_positives.falsePositivesDeserializer
      });
    case 'investigation_fields':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _investigation_fields.InvestigationFieldsEdit,
        ruleFieldFormSchema: _investigation_fields.investigationFieldsSchema,
        serializer: _investigation_fields.investigationFieldsSerializer,
        deserializer: _investigation_fields.investigationFieldsDeserializer
      });
    case 'max_signals':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _max_signals.MaxSignalsEdit,
        ruleFieldFormSchema: _max_signals.maxSignalsSchema,
        serializer: _max_signals.maxSignalsSerializer,
        deserializer: _max_signals.maxSignalsDeserializer
      });
    case 'name':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _name.NameEdit,
        ruleFieldFormSchema: _name.nameSchema
      });
    case 'note':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _note.NoteEdit,
        ruleFieldFormSchema: _note.noteSchema
      });
    case 'references':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _references.ReferencesEdit,
        ruleFieldFormSchema: _references.referencesSchema,
        serializer: _references.referencesSerializer
      });
    case 'related_integrations':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _related_integrations.RelatedIntegrationsEdit,
        ruleFieldFormSchema: _related_integrations.relatedIntegrationsSchema,
        serializer: _related_integrations.relatedIntegrationsSerializer,
        deserializer: _related_integrations.relatedIntegrationsDeserializer
      });
    case 'required_fields':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _required_fields.RequiredFieldsEdit,
        ruleFieldFormSchema: _required_fields.requiredFieldsSchema,
        serializer: _required_fields.requiredFieldsSerializer,
        deserializer: _required_fields.requiredFieldsDeserializer
      });
    case 'risk_score':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _risk_score.RiskScoreEdit,
        ruleFieldFormSchema: _risk_score.riskScoreSchema,
        serializer: _risk_score.riskScoreSerializer,
        deserializer: _risk_score.riskScoreDeserializer
      });
    case 'risk_score_mapping':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _risk_score_mapping.RiskScoreMappingEdit,
        serializer: _risk_score_mapping.riskScoreMappingSerializer,
        deserializer: _risk_score_mapping.riskScoreMappingDeserializer
      });
    case 'rule_name_override':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _rule_name_override.RuleNameOverrideEdit,
        ruleFieldFormSchema: _rule_name_override.ruleNameOverrideSchema,
        serializer: _rule_name_override.ruleNameOverrideSerializer,
        deserializer: _rule_name_override.ruleNameOverrideDeserializer
      });
    case 'rule_schedule':
      return /*#__PURE__*/_react.default.createElement(_rule_schedule.RuleScheduleForm, null);
    case 'setup':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _setup.SetupEdit,
        ruleFieldFormSchema: _setup.setupSchema
      });
    case 'severity':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _severity.SeverityEdit
      });
    case 'severity_mapping':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _severity_mapping.SeverityMappingEdit,
        serializer: _severity_mapping.severityMappingSerializer,
        deserializer: _severity_mapping.severityMappingDeserializer
      });
    case 'tags':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _tags.TagsEdit,
        ruleFieldFormSchema: _tags.tagsSchema
      });
    case 'timeline_template':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _timeline_template.TimelineTemplateEdit,
        ruleFieldFormSchema: _timeline_template.timelineTemplateSchema,
        serializer: _timeline_template.timelineTemplateSerializer,
        deserializer: _timeline_template.timelineTemplateDeserializer
      });
    case 'timestamp_override':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _timestamp_override.TimestampOverrideEdit,
        ruleFieldFormSchema: _timestamp_override.timestampOverrideSchema,
        serializer: _timestamp_override.timestampOverrideSerializer,
        deserializer: _timestamp_override.timestampOverrideDeserializer
      });
    case 'threat':
      return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
        component: _threat.ThreatEdit,
        ruleFieldFormSchema: _threat.threatSchema,
        serializer: _threat.threatSerializer
      });
    default:
      return null;
    // Will be replaced with `assertUnreachable(fieldName)` once all fields are implemented
  }
}