"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatusIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleStatusIconStyled = _styledComponents.default.div`
  position: relative;
  svg {
    position: absolute;
    top: 8px;
    left: 9px;
  }
`;
const RuleStatusIconComponent = ({
  name,
  type
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = type === 'passive' ? euiTheme.colors.backgroundBaseDisabled : euiTheme.colors.primary;
  return /*#__PURE__*/_react.default.createElement(RuleStatusIconStyled, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    color: color,
    name: type === 'valid' ? '' : name,
    size: "l",
    "aria-label": name
  }), type === 'valid' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: euiTheme.colors.backgroundBasePlain,
    size: "l"
  }) : null);
};
const RuleStatusIcon = exports.RuleStatusIcon = /*#__PURE__*/(0, _react.memo)(RuleStatusIconComponent);