"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEsqlQueryColumns = fetchEsqlQueryColumns;
exports.useEsqlQueryColumns = useEsqlQueryColumns;
var _reactQuery = require("@tanstack/react-query");
var _esqlUtils = require("@kbn/esql-utils");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STALE_TIME = 60 * 1000;
async function fetchEsqlQueryColumns({
  esqlQuery,
  queryClient
}) {
  const data = await queryClient.fetchQuery(createSharedTanstackQueryOptions(esqlQuery));
  if (data instanceof Error) {
    throw data;
  }
  return data;
}
function useEsqlQueryColumns(esqlQuery) {
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    ...createSharedTanstackQueryOptions(esqlQuery),
    retryOnMount: false,
    refetchOnMount: false,
    refetchOnWindowFocus: false
  });
  return {
    columns: !data || data instanceof Error ? [] : data,
    isLoading
  };
}
function createSharedTanstackQueryOptions(esqlQuery) {
  return {
    queryKey: [esqlQuery.trim()],
    queryFn: queryEsqlColumnsFactory(esqlQuery),
    staleTime: DEFAULT_STALE_TIME,
    retry: false
  };
}
function queryEsqlColumnsFactory(esqlQuery) {
  return async ({
    signal
  }) => {
    if (esqlQuery.trim() === '') {
      return [];
    }
    try {
      return await (0, _esqlUtils.getESQLQueryColumns)({
        esqlQuery,
        search: _kibana.KibanaServices.get().data.search.search,
        signal
      });
    } catch (e) {
      return e;
    }
  };
}