"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostNameFromEntity = exports.convertAnomaliesToHosts = void 0;
var _get_host_name_from_influencers = require("../influencers/get_host_name_from_influencers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertAnomaliesToHosts = (anomalies, jobNameById, hostName) => {
  if (anomalies == null) {
    return [];
  } else {
    return anomalies.anomalies.reduce((accum, item) => {
      if (getHostNameFromEntity(item, hostName)) {
        var _jobNameById$item$job;
        return [...accum, {
          hostName: item.entityValue,
          jobName: (_jobNameById$item$job = jobNameById[item.jobId]) !== null && _jobNameById$item$job !== void 0 ? _jobNameById$item$job : item.jobId,
          anomaly: item
        }];
      } else {
        const hostNameFromInfluencers = (0, _get_host_name_from_influencers.getHostNameFromInfluencers)(item.influencers, hostName);
        if (hostNameFromInfluencers != null) {
          var _jobNameById$item$job2;
          return [...accum, {
            hostName: hostNameFromInfluencers,
            jobName: (_jobNameById$item$job2 = jobNameById[item.jobId]) !== null && _jobNameById$item$job2 !== void 0 ? _jobNameById$item$job2 : item.jobId,
            anomaly: item
          }];
        } else {
          return accum;
        }
      }
    }, []);
  }
};
exports.convertAnomaliesToHosts = convertAnomaliesToHosts;
const getHostNameFromEntity = (anomaly, hostName) => {
  if (anomaly.entityName !== 'host.name') {
    return false;
  } else if (hostName == null) {
    return true;
  } else {
    return anomaly.entityValue === hostName;
  }
};
exports.getHostNameFromEntity = getHostNameFromEntity;