"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInfluencersFromScore = exports.createEntityFromRecord = exports.createEntity = exports.createEntitiesFromScore = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEntityFromRecord = entity => createEntity(Object.keys(entity)[0], Object.values(entity)[0]);
exports.createEntityFromRecord = createEntityFromRecord;
const createEntity = (entityName, entityValue) => `${entityName}:'${entityValue}'`;
exports.createEntity = createEntity;
const createInfluencersFromScore = (influencers = []) => influencers.reduce((accum, item, index) => {
  if (index === 0) {
    return createEntityFromRecord(item);
  } else {
    return `${accum},${createEntityFromRecord(item)}`;
  }
}, '');
exports.createInfluencersFromScore = createInfluencersFromScore;
const createEntitiesFromScore = score => {
  const influencers = createInfluencersFromScore(score.influencers);
  if (influencers.length === 0) {
    return createEntity(score.entityName, score.entityValue);
  } else if (!influencers.includes(score.entityName)) {
    return `${influencers},${createEntity(score.entityName, score.entityValue)}`;
  } else {
    return influencers;
  }
};
exports.createEntitiesFromScore = createEntitiesFromScore;