"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureAccountTypeSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _asset_boxed_radio_group = require("../asset_boxed_radio_group");
var _constants = require("./constants");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAzureAccountTypeOptions = () => [{
  id: _constants.AZURE_ORGANIZATION_ACCOUNT,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureAccountType.azureOrganizationLabel', {
    defaultMessage: 'Azure Organization'
  }),
  testId: 'azureOrganizationAccountTestId'
}, {
  id: _constants.AZURE_SINGLE_ACCOUNT,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureAccountType.singleAccountLabel', {
    defaultMessage: 'Single Subscription'
  }),
  testId: 'azureSingleAccountTestId'
}];
const getAzureAccountType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars['azure.account_type']) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
};
const AzureAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  disabled,
  setupTechnology
}) => {
  const azureAccountTypeOptions = getAzureAccountTypeOptions();
  const isAgentless = setupTechnology === _public.SetupTechnology.AGENTLESS;
  (0, _react.useEffect)(() => {
    if (!getAzureAccountType(input)) {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'azure.account_type': {
          value: _constants.AZURE_ORGANIZATION_ACCOUNT,
          type: 'text'
        },
        'azure.credentials.type': {
          value: isAgentless ? _constants.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET : _constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureAccountTypeDescriptionLabel",
    defaultMessage: "Select between onboarding an Azure Organization (tenant root group) or a single Azure subscription, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getAzureAccountType(input) || '',
    options: azureAccountTypeOptions,
    onChange: accountType => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'azure.account_type': {
          value: accountType,
          type: 'text'
        }
      }));
    },
    size: "m",
    name: "azureAccountType"
  }), getAzureAccountType(input) === _constants.AZURE_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureAccountType.azureOrganizationDescription",
    defaultMessage: "Connect Elastic to every Azure Subscription (current and future) in your environment by providing Elastic with read-only (configuration) access to your Azure Organization (tenant root group)."
  }))), getAzureAccountType(input) === _constants.AZURE_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.azureAccountType.singleAccountDescription",
    defaultMessage: "Deploying to a single subscription is suitable for an initial POC. To ensure compete coverage, it is strongly recommended to deploy Cloud Asset Discovery at the organization (tenant root group) level, which automatically connects all subscriptions (both current and future)."
  }))));
};
exports.AzureAccountTypeSelect = AzureAccountTypeSelect;