"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewNotFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_install_data_view = require("./hooks/use_install_data_view");
var _asset_inventory_title = require("../asset_inventory_title");
var _centered_wrapper = require("../onboarding/centered_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewNotFound = ({
  refetchDataView
}) => {
  const {
    isInstalling,
    installDataView,
    error,
    reset
  } = (0, _use_install_data_view.useInstallDataView)({
    callback: refetchDataView
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, null), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.dataViewNotFound.title",
      defaultMessage: "Unable to show your Inventory"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.dataViewNotFound.description",
      defaultMessage: "The data view needed to display this page can't be found. It may have been deleted or renamed. You can try create it again to fix this."
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: installDataView,
      isLoading: isInstalling
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.dataViewNotFound.resetFiltersButton",
      defaultMessage: "Create Asset Inventory DataView"
    }))],
    footer: error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      onDismiss: reset,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.dataViewNotFound.error.title",
        defaultMessage: "There was an error creating the data view"
      }),
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.dataViewNotFound.error.description",
      defaultMessage: "Check if you have the necessary permissions to create the data view."
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.dataViewNotFound.error.errorTitle",
      defaultMessage: "Error:"
    }), ' '), error)) : null
  }))));
};
exports.DataViewNotFound = DataViewNotFound;