"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleElementClick = exports.AssetInventoryBarChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _constants = require("../constants");
var _data_view_context = require("../hooks/data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chartTitle = _i18n.i18n.translate('xpack.securitySolution.assetInventory.topAssetsBarChart.chartTitle', {
  defaultMessage: 'Top 10 Asset types'
});
const yAxisTitle = _i18n.i18n.translate('xpack.securitySolution.assetInventory.topAssetsBarChart.yAxisTitle', {
  defaultMessage: 'Count of Assets'
});
const getChartStyles = (euiTheme, xsFontSize) => {
  return (0, _react2.css)({
    height: '260px',
    border: euiTheme.border.thin,
    borderRadius: euiTheme.border.radius.medium,
    padding: euiTheme.size.l,
    '.echLegendItem__label': {
      fontSize: xsFontSize.fontSize
    },
    '.echLegendItem__action': {
      fontSize: xsFontSize.fontSize
    }
  });
};
const getProgressStyle = isFetching => {
  return {
    opacity: isFetching ? 1 : 0
  };
};
const createAssetFilter = (key, value, index) => {
  return {
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    meta: {
      alias: null,
      disabled: false,
      index,
      key,
      negate: false,
      params: {
        query: value
      },
      type: 'phrase'
    },
    query: {
      match_phrase: {
        [key]: value
      }
    }
  };
};
const handleElementClick = (elements, setQuery, index) => {
  if (!elements.length) return;
  const [[geometryValue]] = elements;
  const datum = geometryValue.datum;
  const subtype = datum[_constants.ASSET_FIELDS.ENTITY_SUB_TYPE];
  const type = datum[_constants.ASSET_FIELDS.ENTITY_TYPE];
  const filters = [createAssetFilter(_constants.ASSET_FIELDS.ENTITY_TYPE, type, index), createAssetFilter(_constants.ASSET_FIELDS.ENTITY_SUB_TYPE, subtype, index)];
  setQuery({
    filters
  });
};
exports.handleElementClick = handleElementClick;
const AssetInventoryBarChart = ({
  isLoading,
  isFetching,
  assetInventoryChartData,
  setQuery
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs');
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  if (!dataView.id) {
    return null;
  }
  const dataViewId = dataView.id;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: getChartStyles(euiTheme, xsFontSize)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    css: getProgressStyle(isFetching)
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    css: {
      height: '100%',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  })) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    title: chartTitle
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    theme: {
      legend: {
        spacingBuffer: 120,
        labelOptions: {
          maxLines: 1
        }
      },
      chartMargins: {
        top: 16,
        right: 0,
        bottom: 0,
        left: 0
      },
      axes: {
        axisTitle: {
          fontSize: euiTheme.font.scale.xs * euiTheme.base // convert rem -> px
        }
      }
    },
    showLegend: true,
    animateData: true,
    legendPosition: _charts.Position.Right,
    legendSize: 250,
    legendAction: param => {
      const seriesData = assetInventoryChartData.find(data => data[_constants.ASSET_FIELDS.ENTITY_SUB_TYPE] === param.label);
      const count = !seriesData ? 0 : (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(seriesData.count);
      return /*#__PURE__*/_react.default.createElement("span", null, count);
    },
    onElementClick: elements => handleElementClick(elements, setQuery, dataViewId)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "X-axis",
    position: _charts.Position.Bottom,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "Y-axis",
    position: _charts.Position.Left,
    title: yAxisTitle,
    maximumFractionDigits: 0,
    showOverlappingTicks: false,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "grouped-entity-types",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: _constants.ASSET_FIELDS.ENTITY_TYPE,
    yAccessors: ['count'],
    yNice: true,
    splitSeriesAccessors: [_constants.ASSET_FIELDS.ENTITY_SUB_TYPE],
    stackAccessors: [_constants.ASSET_FIELDS.ENTITY_TYPE],
    minBarHeight: 1,
    data: assetInventoryChartData
  })));
};
exports.AssetInventoryBarChart = AssetInventoryBarChart;