"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegedMonitorBaseIndexName = exports.defaultMonitoringUsersIndex = exports.PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = exports.ML_ANOMALIES_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Static index names: may be more obvious and easier to manage.
const privilegedMonitorBaseIndexName = exports.privilegedMonitorBaseIndexName = '.entity_analytics.monitoring';
const ML_ANOMALIES_INDEX = exports.ML_ANOMALIES_INDEX = '.ml-anomalies-shared';

// Default index for privileged monitoring users.
const defaultMonitoringUsersIndex = namespace => `entity_analytics.privileged_monitoring.${namespace}`;
exports.defaultMonitoringUsersIndex = defaultMonitoringUsersIndex;
const PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = exports.PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = '/api/entity_analytics/monitoring/privileges/privileges';