"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeRuleResponse = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _time_duration = require("@kbn/securitysolution-utils/time_duration");
var _date_math = require("@kbn/securitysolution-utils/date_math");
var _constants = require("../../../constants");
var _utility_types = require("../../../utility_types");
var _utils = require("../../rule_management/utils");
var _normalizers = require("./normalizers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeRuleResponse = rule => {
  const typeSpecificFields = normalizeTypeSpecificFields(rule);
  const commonFields = normalizeCommonResponseFields(rule);

  // Needed to correctly narrow typescript types, we add in the correctly typed alert suppression field in the type-specific normalization
  const {
    alert_suppression: unUsedField,
    ...existingRule
  } = rule;
  return {
    ...existingRule,
    ...commonFields,
    ...typeSpecificFields
  };
};
exports.normalizeRuleResponse = normalizeRuleResponse;
const normalizeCommonResponseFields = rule => {
  var _rule$name, _rule$tags, _rule$severity_mappin, _rule$risk_score_mapp, _rule$risk_score_mapp2, _rule$references, _rule$false_positives, _rule$note, _rule$setup, _rule$related_integra, _TimeDuration$parse, _rule$from, _rule$to, _rule$max_signals, _rule$timestamp_overr;
  return {
    name: (_rule$name = rule.name) === null || _rule$name === void 0 ? void 0 : _rule$name.trim(),
    description: rule.description,
    risk_score: rule.risk_score,
    severity: rule.severity,
    version: rule.version,
    enabled: rule.enabled,
    exceptions_list: rule.exceptions_list,
    actions: rule.actions,
    author: rule.author,
    tags: (_rule$tags = rule.tags) !== null && _rule$tags !== void 0 ? _rule$tags : [],
    severity_mapping: (_rule$severity_mappin = rule.severity_mapping) !== null && _rule$severity_mappin !== void 0 ? _rule$severity_mappin : [],
    risk_score_mapping: (_rule$risk_score_mapp = (_rule$risk_score_mapp2 = rule.risk_score_mapping) === null || _rule$risk_score_mapp2 === void 0 ? void 0 : _rule$risk_score_mapp2.map(mapping => (0, _zodHelpers.requiredOptional)(mapping))) !== null && _rule$risk_score_mapp !== void 0 ? _rule$risk_score_mapp : [],
    references: (_rule$references = rule.references) !== null && _rule$references !== void 0 ? _rule$references : [],
    false_positives: (_rule$false_positives = rule.false_positives) !== null && _rule$false_positives !== void 0 ? _rule$false_positives : [],
    threat: (0, _normalizers.normalizeThreatArray)(rule.threat),
    note: (_rule$note = rule.note) !== null && _rule$note !== void 0 ? _rule$note : '',
    setup: (_rule$setup = rule.setup) !== null && _rule$setup !== void 0 ? _rule$setup : '',
    related_integrations: (_rule$related_integra = rule.related_integrations) !== null && _rule$related_integra !== void 0 ? _rule$related_integra : [],
    required_fields: (0, _utils.addEcsToRequiredFields)(rule.required_fields),
    interval: ((_TimeDuration$parse = _time_duration.TimeDuration.parse(rule.interval)) !== null && _TimeDuration$parse !== void 0 ? _TimeDuration$parse : new _time_duration.TimeDuration(5, 'm')).toString(),
    from: (0, _date_math.normalizeDateMath)((_rule$from = rule.from) !== null && _rule$from !== void 0 ? _rule$from : 'now-6m'),
    to: (0, _date_math.normalizeDateMath)((_rule$to = rule.to) !== null && _rule$to !== void 0 ? _rule$to : 'now'),
    max_signals: (_rule$max_signals = rule.max_signals) !== null && _rule$max_signals !== void 0 ? _rule$max_signals : _constants.DEFAULT_MAX_SIGNALS,
    timestamp_override_fallback_disabled: (_rule$timestamp_overr = rule.timestamp_override_fallback_disabled) !== null && _rule$timestamp_overr !== void 0 ? _rule$timestamp_overr : false,
    id: rule.id,
    rule_id: rule.rule_id,
    rule_source: rule.rule_source,
    immutable: rule.immutable,
    created_at: rule.created_at,
    created_by: rule.created_by,
    updated_at: rule.updated_at,
    updated_by: rule.updated_by,
    revision: rule.revision
  };
};
const normalizeTypeSpecificFields = rule => {
  switch (rule.type) {
    case 'query':
      {
        var _rule$language;
        return {
          type: rule.type,
          language: (_rule$language = rule.language) !== null && _rule$language !== void 0 ? _rule$language : 'kuery',
          index: rule.index,
          data_view_id: rule.data_view_id,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          saved_id: rule.saved_id,
          alert_suppression: rule.alert_suppression
        };
      }
    case 'saved_query':
      {
        var _rule$language2;
        return {
          type: rule.type,
          language: (_rule$language2 = rule.language) !== null && _rule$language2 !== void 0 ? _rule$language2 : 'kuery',
          index: rule.index,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          saved_id: rule.saved_id,
          data_view_id: rule.data_view_id,
          alert_suppression: rule.alert_suppression
        };
      }
    case 'eql':
      {
        return {
          type: rule.type,
          language: rule.language,
          index: rule.index,
          data_view_id: rule.data_view_id,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          timestamp_field: rule.timestamp_field,
          event_category_override: rule.event_category_override,
          tiebreaker_field: rule.tiebreaker_field,
          alert_suppression: rule.alert_suppression
        };
      }
    case 'esql':
      {
        return {
          type: rule.type,
          language: rule.language,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          alert_suppression: rule.alert_suppression
        };
      }
    case 'threat_match':
      {
        var _rule$language3;
        return {
          type: rule.type,
          language: (_rule$language3 = rule.language) !== null && _rule$language3 !== void 0 ? _rule$language3 : 'kuery',
          index: rule.index,
          data_view_id: rule.data_view_id,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          saved_id: rule.saved_id,
          threat_filters: rule.threat_filters,
          threat_query: (0, _normalizers.normalizeQueryField)(rule.threat_query),
          threat_mapping: rule.threat_mapping,
          threat_language: rule.threat_language,
          threat_index: rule.threat_index,
          threat_indicator_path: rule.threat_indicator_path,
          concurrent_searches: rule.concurrent_searches,
          items_per_search: rule.items_per_search,
          alert_suppression: rule.alert_suppression
        };
      }
    case 'threshold':
      {
        var _rule$language4;
        return {
          type: rule.type,
          language: (_rule$language4 = rule.language) !== null && _rule$language4 !== void 0 ? _rule$language4 : 'kuery',
          index: rule.index,
          data_view_id: rule.data_view_id,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          saved_id: rule.saved_id,
          threshold: (0, _normalizers.normalizeRuleThreshold)(rule.threshold),
          alert_suppression: rule.alert_suppression
        };
      }
    case 'machine_learning':
      {
        return {
          type: rule.type,
          anomaly_threshold: rule.anomaly_threshold,
          machine_learning_job_id: rule.machine_learning_job_id,
          alert_suppression: rule.alert_suppression
        };
      }
    case 'new_terms':
      {
        var _rule$language5;
        return {
          type: rule.type,
          query: (0, _normalizers.normalizeQueryField)(rule.query),
          new_terms_fields: rule.new_terms_fields,
          history_window_start: rule.history_window_start,
          index: rule.index,
          filters: (0, _normalizers.normalizeFilterArray)(rule.filters),
          language: (_rule$language5 = rule.language) !== null && _rule$language5 !== void 0 ? _rule$language5 : 'kuery',
          data_view_id: rule.data_view_id,
          alert_suppression: rule.alert_suppression
        };
      }
    default:
      {
        return (0, _utility_types.assertUnreachable)(rule);
      }
  }
};